/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.metadata.reference;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.util.Date;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.metadata.Metadata;
import mil.nga.geopackage.metadata.reference.MetadataReferenceDao;
import mil.nga.geopackage.metadata.reference.ReferenceScopeType;
import mil.nga.geopackage.persister.DatePersister;

@DatabaseTable(tableName="gpkg_metadata_reference", daoClass=MetadataReferenceDao.class)
public class MetadataReference {
    public static final String TABLE_NAME = "gpkg_metadata_reference";
    public static final String COLUMN_REFERENCE_SCOPE = "reference_scope";
    public static final String COLUMN_TABLE_NAME = "table_name";
    public static final String COLUMN_COLUMN_NAME = "column_name";
    public static final String COLUMN_ROW_ID_VALUE = "row_id_value";
    public static final String COLUMN_TIMESTAMP = "timestamp";
    public static final String COLUMN_FILE_ID = "md_file_id";
    public static final String COLUMN_PARENT_ID = "md_parent_id";
    @DatabaseField(columnName="reference_scope", canBeNull=false)
    private String referenceScope;
    @DatabaseField(columnName="table_name")
    private String tableName;
    @DatabaseField(columnName="column_name")
    private String columnName;
    @DatabaseField(columnName="row_id_value")
    private Long rowIdValue;
    @DatabaseField(columnName="timestamp", persisterClass=DatePersister.class, canBeNull=false)
    private Date timestamp;
    @DatabaseField(columnName="md_file_id", canBeNull=false, foreign=true, foreignAutoRefresh=true)
    private Metadata metadata;
    @DatabaseField(columnName="md_file_id", canBeNull=false)
    private long fileId;
    @DatabaseField(columnName="md_parent_id", foreign=true, foreignAutoRefresh=true)
    private Metadata parentMetadata;
    @DatabaseField(columnName="md_parent_id")
    private Long parentId;

    public ReferenceScopeType getReferenceScope() {
        return ReferenceScopeType.fromValue(this.referenceScope);
    }

    public void setReferenceScope(ReferenceScopeType referenceScope) {
        this.referenceScope = referenceScope.getValue();
        switch (referenceScope) {
            case GEOPACKAGE: {
                this.setTableName(null);
                this.setColumnName(null);
                this.setRowIdValue(null);
                break;
            }
            case TABLE: {
                this.setColumnName(null);
                this.setRowIdValue(null);
                break;
            }
            case ROW: {
                this.setColumnName(null);
                break;
            }
            case COLUMN: {
                this.setRowIdValue(null);
                break;
            }
            case ROW_COL: {
                break;
            }
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        if (this.referenceScope != null && tableName != null && this.getReferenceScope().equals((Object)ReferenceScopeType.GEOPACKAGE)) {
            throw new GeoPackageException("The table name must be null for " + (Object)((Object)ReferenceScopeType.GEOPACKAGE) + " reference scope");
        }
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        ReferenceScopeType scopeType;
        if (this.referenceScope != null && columnName != null && ((scopeType = this.getReferenceScope()).equals((Object)ReferenceScopeType.GEOPACKAGE) || scopeType.equals((Object)ReferenceScopeType.TABLE) || scopeType.equals((Object)ReferenceScopeType.ROW))) {
            throw new GeoPackageException("The column name must be null for " + (Object)((Object)scopeType) + " reference scope");
        }
        this.columnName = columnName;
    }

    public Long getRowIdValue() {
        return this.rowIdValue;
    }

    public void setRowIdValue(Long rowIdValue) {
        ReferenceScopeType scopeType;
        if (this.referenceScope != null && rowIdValue != null && ((scopeType = this.getReferenceScope()).equals((Object)ReferenceScopeType.GEOPACKAGE) || scopeType.equals((Object)ReferenceScopeType.TABLE) || scopeType.equals((Object)ReferenceScopeType.COLUMN))) {
            throw new GeoPackageException("The row id value must be null for " + (Object)((Object)scopeType) + " reference scope");
        }
        this.rowIdValue = rowIdValue;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
        this.fileId = metadata != null ? metadata.getId() : -1L;
    }

    public long getFileId() {
        return this.fileId;
    }

    public Metadata getParentMetadata() {
        return this.parentMetadata;
    }

    public void setParentMetadata(Metadata parentMetadata) {
        this.parentMetadata = parentMetadata;
        this.parentId = parentMetadata != null ? parentMetadata.getId() : -1L;
    }

    public Long getParentId() {
        return this.parentId;
    }
}

