/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.persister;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.StringType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatePersister
extends StringType {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final Logger logger = Logger.getLogger(DatePersister.class.getName());
    private static final DatePersister singleTon = new DatePersister();
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    private DatePersister() {
        super(SqlType.STRING, new Class[]{Date.class});
    }

    public static DatePersister getSingleton() {
        return singleTon;
    }

    public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
        String stringDate = null;
        if (javaObject != null && javaObject instanceof Date) {
            stringDate = sdf.format((Date)javaObject);
        }
        return stringDate;
    }

    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
        Date javaDate = null;
        if (sqlArg != null && sqlArg instanceof String) {
            try {
                javaDate = sdf.parse((String)sqlArg);
            }
            catch (ParseException e) {
                logger.log(Level.SEVERE, "Failed to parse date string: " + sqlArg + ", expected format: " + DATE_FORMAT, e);
            }
        }
        return javaDate;
    }

    static {
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

