/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.projection;

import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.projection.ProjectionTransform;
import mil.nga.wkb.geom.CircularString;
import mil.nga.wkb.geom.CompoundCurve;
import mil.nga.wkb.geom.Curve;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.GeometryCollection;
import mil.nga.wkb.geom.GeometryType;
import mil.nga.wkb.geom.LineString;
import mil.nga.wkb.geom.MultiLineString;
import mil.nga.wkb.geom.MultiPoint;
import mil.nga.wkb.geom.MultiPolygon;
import mil.nga.wkb.geom.Point;
import mil.nga.wkb.geom.Polygon;
import mil.nga.wkb.geom.PolyhedralSurface;
import mil.nga.wkb.geom.TIN;
import mil.nga.wkb.geom.Triangle;
import org.osgeo.proj4j.ProjCoordinate;

public class GeometryProjectionTransform {
    private final ProjectionTransform transform;

    public GeometryProjectionTransform(ProjectionTransform transform) {
        this.transform = transform;
    }

    public Geometry transform(Geometry geometry) {
        GeometryCollection<Geometry> to = null;
        GeometryType geometryType = geometry.getGeometryType();
        switch (geometryType) {
            case POINT: {
                to = this.transform((Point)geometry);
                break;
            }
            case LINESTRING: {
                to = this.transform((LineString)geometry);
                break;
            }
            case POLYGON: {
                to = this.transform((Polygon)geometry);
                break;
            }
            case MULTIPOINT: {
                to = this.transform((MultiPoint)geometry);
                break;
            }
            case MULTILINESTRING: {
                to = this.transform((MultiLineString)geometry);
                break;
            }
            case MULTIPOLYGON: {
                to = this.transform((MultiPolygon)geometry);
                break;
            }
            case CIRCULARSTRING: {
                to = this.transform((CircularString)geometry);
                break;
            }
            case COMPOUNDCURVE: {
                to = this.transform((CompoundCurve)geometry);
                break;
            }
            case POLYHEDRALSURFACE: {
                to = this.transform((PolyhedralSurface)geometry);
                break;
            }
            case TIN: {
                to = this.transform((TIN)geometry);
                break;
            }
            case TRIANGLE: {
                to = this.transform((Triangle)geometry);
                break;
            }
            case GEOMETRYCOLLECTION: {
                GeometryCollection<Geometry> toCollection;
                to = toCollection = this.transform((GeometryCollection<Geometry>)((GeometryCollection)geometry));
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported Geometry Type: " + geometryType);
            }
        }
        return to;
    }

    public Point transform(Point from) {
        ProjCoordinate fromCoord = from.hasZ() ? new ProjCoordinate(from.getX(), from.getY(), from.getZ() != null ? from.getZ() : Double.NaN) : new ProjCoordinate(from.getX(), from.getY());
        ProjCoordinate toCoord = this.transform.transform(fromCoord);
        Point to = new Point(from.hasZ(), from.hasM(), toCoord.x, toCoord.y);
        if (from.hasZ()) {
            if (Double.isNaN(toCoord.z)) {
                to.setZ(from.getZ());
            } else {
                to.setZ(Double.valueOf(toCoord.z));
            }
        }
        if (from.hasM()) {
            to.setM(from.getM());
        }
        return to;
    }

    public LineString transform(LineString lineString) {
        LineString to = new LineString(lineString.hasZ(), lineString.hasM());
        for (Point point : lineString.getPoints()) {
            Point toPoint = this.transform(point);
            to.addPoint(toPoint);
        }
        return to;
    }

    public Polygon transform(Polygon polygon) {
        Polygon to = new Polygon(polygon.hasZ(), polygon.hasM());
        for (LineString ring : polygon.getRings()) {
            LineString toRing = this.transform(ring);
            to.addRing((Curve)toRing);
        }
        return to;
    }

    public MultiPoint transform(MultiPoint multiPoint) {
        MultiPoint to = new MultiPoint(multiPoint.hasZ(), multiPoint.hasM());
        for (Point point : multiPoint.getPoints()) {
            Point toPoint = this.transform(point);
            to.addPoint(toPoint);
        }
        return to;
    }

    public MultiLineString transform(MultiLineString multiLineString) {
        MultiLineString to = new MultiLineString(multiLineString.hasZ(), multiLineString.hasM());
        for (LineString lineString : multiLineString.getLineStrings()) {
            LineString toLineString = this.transform(lineString);
            to.addLineString(toLineString);
        }
        return to;
    }

    public MultiPolygon transform(MultiPolygon multiPolygon) {
        MultiPolygon to = new MultiPolygon(multiPolygon.hasZ(), multiPolygon.hasM());
        for (Polygon polygon : multiPolygon.getPolygons()) {
            Polygon toPolygon = this.transform(polygon);
            to.addPolygon(toPolygon);
        }
        return to;
    }

    public CircularString transform(CircularString circularString) {
        CircularString to = new CircularString(circularString.hasZ(), circularString.hasM());
        for (Point point : circularString.getPoints()) {
            Point toPoint = this.transform(point);
            to.addPoint(toPoint);
        }
        return to;
    }

    public CompoundCurve transform(CompoundCurve compoundCurve) {
        CompoundCurve to = new CompoundCurve(compoundCurve.hasZ(), compoundCurve.hasM());
        for (LineString lineString : compoundCurve.getLineStrings()) {
            LineString toLineString = this.transform(lineString);
            to.addLineString(toLineString);
        }
        return to;
    }

    public PolyhedralSurface transform(PolyhedralSurface polyhedralSurface) {
        PolyhedralSurface to = new PolyhedralSurface(polyhedralSurface.hasZ(), polyhedralSurface.hasM());
        for (Polygon polygon : polyhedralSurface.getPolygons()) {
            Polygon toPolygon = this.transform(polygon);
            to.addPolygon(toPolygon);
        }
        return to;
    }

    public TIN transform(TIN tin) {
        TIN to = new TIN(tin.hasZ(), tin.hasM());
        for (Polygon polygon : tin.getPolygons()) {
            Polygon toPolygon = this.transform(polygon);
            to.addPolygon(toPolygon);
        }
        return to;
    }

    public Triangle transform(Triangle triangle) {
        Triangle to = new Triangle(triangle.hasZ(), triangle.hasM());
        for (LineString ring : triangle.getRings()) {
            LineString toRing = this.transform(ring);
            to.addRing((Curve)toRing);
        }
        return to;
    }

    public GeometryCollection<Geometry> transform(GeometryCollection<Geometry> geometryCollection) {
        GeometryCollection to = new GeometryCollection(geometryCollection.hasZ(), geometryCollection.hasM());
        for (Geometry geometry : geometryCollection.getGeometries()) {
            Geometry toGeometry = this.transform(geometry);
            to.addGeometry(toGeometry);
        }
        return to;
    }
}

