/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.projection;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.projection.Projection;
import mil.nga.geopackage.projection.ProjectionRetriever;
import org.osgeo.proj4j.CRSFactory;
import org.osgeo.proj4j.CoordinateReferenceSystem;

public class ProjectionFactory {
    private static final Logger logger = Logger.getLogger(ProjectionFactory.class.getName());
    private static Map<Long, Projection> projections = new HashMap<Long, Projection>();
    private static final CRSFactory csFactory = new CRSFactory();

    public static Projection getProjection(long epsg) {
        Projection projection = projections.get(epsg);
        if (projection == null) {
            CoordinateReferenceSystem crs = null;
            String parameters = null;
            parameters = epsg == -1L || epsg == 0L ? ProjectionRetriever.getProjection(4326L) : ProjectionRetriever.getProjection(epsg);
            if (parameters != null) {
                try {
                    crs = csFactory.createFromParameters(String.valueOf(epsg), parameters);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to create projection for epsg " + epsg + " from parameters: " + parameters, e);
                }
            }
            String epsgName = null;
            if (crs == null) {
                epsgName = "EPSG:" + epsg;
                try {
                    crs = csFactory.createFromName(epsgName);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to create projection from name: " + epsgName, e);
                }
            }
            if (crs == null) {
                throw new GeoPackageException("Failed to create projection for EPSG " + epsg + ". Parameters: " + parameters + ". Name: " + epsgName);
            }
            projection = new Projection(epsg, crs);
            projections.put(epsg, projection);
        }
        return projection;
    }

    public static Projection getProjection(SpatialReferenceSystem srs) {
        long epsg = srs.getOrganizationCoordsysId();
        Projection projection = ProjectionFactory.getProjection(epsg);
        return projection;
    }
}

