/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.projection;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProjectionRetriever {
    private static final Logger log = Logger.getLogger(ProjectionRetriever.class.getName());
    public static final String PROJECTIONS_PROPERTY_FILE = "projections.properties";
    private static Properties mProperties;

    public static synchronized String getProjection(long epsg) {
        if (mProperties == null) {
            mProperties = ProjectionRetriever.initializeConfigurationProperties();
        }
        return mProperties.getProperty(String.valueOf(epsg));
    }

    private static Properties initializeConfigurationProperties() {
        Properties properties = new Properties();
        InputStream in = ProjectionRetriever.class.getResourceAsStream("/projections.properties");
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to load projections properties file: projections.properties", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Failed to close projections properties file: projections.properties", e);
                }
            }
        } else {
            log.log(Level.SEVERE, "Failed to load projections properties, file not found: projections.properties");
        }
        return properties;
    }
}

