/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.property;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeoPackageProperties {
    private static final Logger log = Logger.getLogger(GeoPackageProperties.class.getName());
    private static Properties mProperties;

    public static String getProperty(String key) {
        return GeoPackageProperties.getProperty(key, true);
    }

    public static synchronized String getProperty(String key, boolean required) {
        String value;
        if (mProperties == null) {
            mProperties = GeoPackageProperties.initializeConfigurationProperties();
        }
        if ((value = mProperties.getProperty(key)) == null && required) {
            throw new RuntimeException("Property not found: " + key);
        }
        return value;
    }

    public static String getProperty(String base, String property) {
        return GeoPackageProperties.getProperty(base, property, true);
    }

    public static synchronized String getProperty(String base, String property, boolean required) {
        return GeoPackageProperties.getProperty(base + "." + property, required);
    }

    public static int getIntegerProperty(String key) {
        return GeoPackageProperties.getIntegerProperty(key, true);
    }

    public static Integer getIntegerProperty(String key, boolean required) {
        Integer value = null;
        String stringValue = GeoPackageProperties.getProperty(key, required);
        if (stringValue != null) {
            value = Integer.valueOf(stringValue);
        }
        return value;
    }

    public static int getIntegerProperty(String base, String property) {
        return GeoPackageProperties.getIntegerProperty(base, property, true);
    }

    public static Integer getIntegerProperty(String base, String property, boolean required) {
        return GeoPackageProperties.getIntegerProperty(base + "." + property, required);
    }

    public static float getFloatProperty(String key) {
        return GeoPackageProperties.getFloatProperty(key, true).floatValue();
    }

    public static Float getFloatProperty(String key, boolean required) {
        Float value = null;
        String stringValue = GeoPackageProperties.getProperty(key, required);
        if (stringValue != null) {
            value = Float.valueOf(stringValue);
        }
        return value;
    }

    public static boolean getBooleanProperty(String key) {
        return GeoPackageProperties.getBooleanProperty(key, true);
    }

    public static Boolean getBooleanProperty(String key, boolean required) {
        Boolean value = null;
        String stringValue = GeoPackageProperties.getProperty(key, required);
        if (stringValue != null) {
            value = Boolean.valueOf(stringValue);
        }
        return value;
    }

    private static Properties initializeConfigurationProperties() {
        Properties properties = new Properties();
        InputStream in = GeoPackageProperties.class.getResourceAsStream("/geopackage.properties");
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to load properties file: geopackage.properties", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Failed to close properties file: geopackage.properties", e);
                }
            }
        } else {
            log.log(Level.SEVERE, "Failed to load properties, file not found: geopackage.properties");
        }
        return properties;
    }
}

