/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.user;

import java.util.Arrays;
import java.util.List;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;

public class TileDaoUtils {
    public static void adjustTileMatrixLengths(TileMatrixSet tileMatrixSet, List<TileMatrix> tileMatrices) {
        double tileMatrixWidth = tileMatrixSet.getMaxX() - tileMatrixSet.getMinX();
        double tileMatrixHeight = tileMatrixSet.getMaxY() - tileMatrixSet.getMinY();
        for (TileMatrix tileMatrix : tileMatrices) {
            int tempMatrixWidth = (int)(tileMatrixWidth / (tileMatrix.getPixelXSize() * (double)tileMatrix.getTileWidth()));
            int tempMatrixHeight = (int)(tileMatrixHeight / (tileMatrix.getPixelYSize() * (double)tileMatrix.getTileHeight()));
            if ((long)tempMatrixWidth > tileMatrix.getMatrixWidth()) {
                tileMatrix.setMatrixWidth(tempMatrixWidth);
            }
            if ((long)tempMatrixHeight <= tileMatrix.getMatrixHeight()) continue;
            tileMatrix.setMatrixHeight(tempMatrixHeight);
        }
    }

    public static Long getZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double length) {
        return TileDaoUtils.getZoomLevel(widths, heights, tileMatrices, length, true);
    }

    public static Long getZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double width, double height) {
        return TileDaoUtils.getZoomLevel(widths, heights, tileMatrices, width, height, true);
    }

    public static Long getClosestZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double length) {
        return TileDaoUtils.getZoomLevel(widths, heights, tileMatrices, length, false);
    }

    public static Long getClosestZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double width, double height) {
        return TileDaoUtils.getZoomLevel(widths, heights, tileMatrices, width, height, false);
    }

    private static Long getZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double length, boolean lengthChecks) {
        return TileDaoUtils.getZoomLevel(widths, heights, tileMatrices, length, length, lengthChecks);
    }

    private static Long getZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double width, double height, boolean lengthChecks) {
        int heightIndex;
        Long zoomLevel = null;
        int widthIndex = Arrays.binarySearch(widths, width);
        if (widthIndex < 0) {
            widthIndex = (widthIndex + 1) * -1;
        }
        if ((heightIndex = Arrays.binarySearch(heights, height)) < 0) {
            heightIndex = (heightIndex + 1) * -1;
        }
        if (widthIndex == 0) {
            if (lengthChecks && width < TileDaoUtils.getMinLength(widths)) {
                widthIndex = -1;
            }
        } else if (widthIndex == widths.length) {
            widthIndex = lengthChecks && width >= TileDaoUtils.getMaxLength(widths) ? -1 : --widthIndex;
        } else if (width - widths[widthIndex - 1] < widths[widthIndex] - width) {
            --widthIndex;
        }
        if (heightIndex == 0) {
            if (lengthChecks && height < TileDaoUtils.getMinLength(heights)) {
                heightIndex = -1;
            }
        } else if (heightIndex == heights.length) {
            heightIndex = lengthChecks && height >= TileDaoUtils.getMaxLength(heights) ? -1 : --heightIndex;
        } else if (height - heights[heightIndex - 1] < heights[heightIndex] - height) {
            --heightIndex;
        }
        if (widthIndex >= 0 || heightIndex >= 0) {
            int index = widthIndex < 0 ? heightIndex : (heightIndex < 0 ? widthIndex : Math.min(widthIndex, heightIndex));
            TileMatrix tileMatrix = tileMatrices.get(tileMatrices.size() - index - 1);
            zoomLevel = tileMatrix.getZoomLevel();
        }
        return zoomLevel;
    }

    public static double getMaxLength(double[] widths, double[] heights) {
        double maxWidth = TileDaoUtils.getMaxLength(widths);
        double maxHeight = TileDaoUtils.getMaxLength(heights);
        double maxLength = Math.min(maxWidth, maxHeight);
        return maxLength;
    }

    public static double getMinLength(double[] widths, double[] heights) {
        double minWidth = TileDaoUtils.getMinLength(widths);
        double minHeight = TileDaoUtils.getMinLength(heights);
        double minLength = Math.max(minWidth, minHeight);
        return minLength;
    }

    private static double getMaxLength(double[] lengths) {
        return lengths[lengths.length - 1] / 0.51;
    }

    private static double getMinLength(double[] lengths) {
        return lengths[0] * 0.51;
    }
}

