/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.validate;

import java.io.File;
import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.io.GeoPackageIOUtils;

public class GeoPackageValidate {
    public static boolean hasGeoPackageExtension(File file) {
        String extension = GeoPackageIOUtils.getFileExtension(file);
        boolean isGeoPackage = extension != null && (extension.equalsIgnoreCase("gpkg") || extension.equalsIgnoreCase("gpkx"));
        return isGeoPackage;
    }

    public static void validateGeoPackageExtension(File file) {
        if (!GeoPackageValidate.hasGeoPackageExtension(file)) {
            throw new GeoPackageException("GeoPackage database file '" + file + "' does not have a valid extension of '" + "gpkg" + "' or '" + "gpkx" + "'");
        }
    }

    public static boolean hasMinimumTables(GeoPackageCore geoPackage) {
        boolean hasMinimum;
        try {
            hasMinimum = geoPackage.getSpatialReferenceSystemDao().isTableExists() && geoPackage.getContentsDao().isTableExists();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check for required minimum GeoPackage tables. GeoPackage Name: " + geoPackage.getName());
        }
        return hasMinimum;
    }

    public static void validateMinimumTables(GeoPackageCore geoPackage) {
        if (!GeoPackageValidate.hasMinimumTables(geoPackage)) {
            throw new GeoPackageException("Invalid GeoPackage. Does not contain required tables: gpkg_spatial_ref_sys & gpkg_contents, GeoPackage Name: " + geoPackage.getName());
        }
    }
}

