/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.elevation;

import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;

public class ElevationRequest {
    private BoundingBox boundingBox;
    private boolean point;
    private BoundingBox projectedBoundingBox;

    public ElevationRequest(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public ElevationRequest(double latitude, double longitude) {
        this(new BoundingBox(longitude, longitude, latitude, latitude));
        this.point = true;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public boolean isPoint() {
        return this.point;
    }

    public BoundingBox getProjectedBoundingBox() {
        return this.projectedBoundingBox;
    }

    public void setProjectedBoundingBox(BoundingBox projectedBoundingBox) {
        this.projectedBoundingBox = projectedBoundingBox;
    }

    public BoundingBox overlap(BoundingBox projectedElevation) {
        BoundingBox overlap = null;
        overlap = this.point ? this.projectedBoundingBox : TileBoundingBoxUtils.overlap(this.projectedBoundingBox, projectedElevation);
        return overlap;
    }
}

