/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.projection;

import java.lang.reflect.Field;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.projection.ProjectionFactory;
import mil.nga.geopackage.projection.ProjectionTransform;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.units.Unit;
import org.osgeo.proj4j.units.Units;

public class Projection {
    private final long epsg;
    private final CoordinateReferenceSystem crs;

    Projection(long epsg, CoordinateReferenceSystem crs) {
        this.epsg = epsg;
        this.crs = crs;
    }

    public long getEpsg() {
        return this.epsg;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public ProjectionTransform getTransformation(long epsg) {
        Projection projectionTo = ProjectionFactory.getProjection(epsg);
        return this.getTransformation(projectionTo);
    }

    public ProjectionTransform getTransformation(SpatialReferenceSystem srs) {
        Projection projectionTo = ProjectionFactory.getProjection(srs);
        return this.getTransformation(projectionTo);
    }

    public ProjectionTransform getTransformation(Projection projection) {
        return new ProjectionTransform(this, projection);
    }

    public double toMeters(double value) {
        return value / this.crs.getProjection().getFromMetres();
    }

    public Unit getUnit() {
        Unit unit = null;
        try {
            Field f = org.osgeo.proj4j.proj.Projection.class.getDeclaredField("unit");
            f.setAccessible(true);
            unit = (Unit)f.get(this.crs.getProjection());
            if (unit == null) {
                unit = Units.METRES;
            }
        }
        catch (Exception e) {
            throw new GeoPackageException("Failed to get projection unit for epsg: " + this.epsg, e);
        }
        return unit;
    }
}

