/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles;

import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.projection.Projection;
import mil.nga.geopackage.projection.ProjectionConstants;
import mil.nga.geopackage.projection.ProjectionFactory;
import mil.nga.geopackage.projection.ProjectionTransform;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.wkb.geom.Point;

public class TileBoundingBoxUtils {
    private static Projection webMercator = ProjectionFactory.getProjection(3857L);

    public static BoundingBox overlap(BoundingBox boundingBox, BoundingBox boundingBox2) {
        double minLongitude = Math.max(boundingBox.getMinLongitude(), boundingBox2.getMinLongitude());
        double maxLongitude = Math.min(boundingBox.getMaxLongitude(), boundingBox2.getMaxLongitude());
        double minLatitude = Math.max(boundingBox.getMinLatitude(), boundingBox2.getMinLatitude());
        double maxLatitude = Math.min(boundingBox.getMaxLatitude(), boundingBox2.getMaxLatitude());
        BoundingBox overlap = null;
        if (minLongitude < maxLongitude && minLatitude < maxLatitude) {
            overlap = new BoundingBox(minLongitude, maxLongitude, minLatitude, maxLatitude);
        }
        return overlap;
    }

    public static BoundingBox union(BoundingBox boundingBox, BoundingBox boundingBox2) {
        double minLongitude = Math.min(boundingBox.getMinLongitude(), boundingBox2.getMinLongitude());
        double maxLongitude = Math.max(boundingBox.getMaxLongitude(), boundingBox2.getMaxLongitude());
        double minLatitude = Math.min(boundingBox.getMinLatitude(), boundingBox2.getMinLatitude());
        double maxLatitude = Math.max(boundingBox.getMaxLatitude(), boundingBox2.getMaxLatitude());
        BoundingBox union = null;
        if (minLongitude < maxLongitude && minLatitude < maxLatitude) {
            union = new BoundingBox(minLongitude, maxLongitude, minLatitude, maxLatitude);
        }
        return union;
    }

    public static float getXPixel(long width, BoundingBox boundingBox, double longitude) {
        double boxWidth = boundingBox.getMaxLongitude() - boundingBox.getMinLongitude();
        double offset = longitude - boundingBox.getMinLongitude();
        double percentage = offset / boxWidth;
        float pixel = (float)(percentage * (double)width);
        return pixel;
    }

    public static double getLongitudeFromPixel(long width, BoundingBox boundingBox, float pixel) {
        double boxWidth = boundingBox.getMaxLongitude() - boundingBox.getMinLongitude();
        double percentage = pixel / (float)width;
        double offset = percentage * boxWidth;
        double longitude = offset + boundingBox.getMinLongitude();
        return longitude;
    }

    public static float getYPixel(long height, BoundingBox boundingBox, double latitude) {
        double boxHeight = boundingBox.getMaxLatitude() - boundingBox.getMinLatitude();
        double offset = boundingBox.getMaxLatitude() - latitude;
        double percentage = offset / boxHeight;
        float pixel = (float)(percentage * (double)height);
        return pixel;
    }

    public static double getLatitudeFromPixel(long height, BoundingBox boundingBox, float pixel) {
        double boxHeight = boundingBox.getMaxLatitude() - boundingBox.getMinLatitude();
        double percentage = pixel / (float)height;
        double offset = percentage * boxHeight;
        double latitude = boundingBox.getMaxLatitude() - offset;
        return latitude;
    }

    public static BoundingBox getBoundingBox(int x, int y, int zoom) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        double tileWidthDegrees = TileBoundingBoxUtils.tileWidthDegrees(tilesPerSide);
        double tileHeightDegrees = TileBoundingBoxUtils.tileHeightDegrees(tilesPerSide);
        double minLon = -180.0 + (double)x * tileWidthDegrees;
        double maxLon = minLon + tileWidthDegrees;
        double maxLat = 90.0 - (double)y * tileHeightDegrees;
        double minLat = maxLat - tileHeightDegrees;
        BoundingBox box = new BoundingBox(minLon, maxLon, minLat, maxLat);
        return box;
    }

    public static BoundingBox getWebMercatorBoundingBox(long x, long y, int zoom) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        double tileSize = TileBoundingBoxUtils.tileSize(tilesPerSide);
        double minLon = -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH + (double)x * tileSize;
        double maxLon = -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH + (double)(x + 1L) * tileSize;
        double minLat = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH - (double)(y + 1L) * tileSize;
        double maxLat = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH - (double)y * tileSize;
        BoundingBox box = new BoundingBox(minLon, maxLon, minLat, maxLat);
        return box;
    }

    public static BoundingBox getWebMercatorBoundingBox(TileGrid tileGrid, int zoom) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        double tileSize = TileBoundingBoxUtils.tileSize(tilesPerSide);
        double minLon = -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH + (double)tileGrid.getMinX() * tileSize;
        double maxLon = -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH + (double)(tileGrid.getMaxX() + 1L) * tileSize;
        double minLat = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH - (double)(tileGrid.getMaxY() + 1L) * tileSize;
        double maxLat = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH - (double)tileGrid.getMinY() * tileSize;
        BoundingBox box = new BoundingBox(minLon, maxLon, minLat, maxLat);
        return box;
    }

    public static BoundingBox getProjectedBoundingBox(Long projectionEpsg, int x, int y, int zoom) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox(x, y, zoom);
        if (projectionEpsg != null) {
            ProjectionTransform transform = webMercator.getTransformation(projectionEpsg);
            boundingBox = transform.transform(boundingBox);
        }
        return boundingBox;
    }

    public static BoundingBox getProjectedBoundingBox(Projection projection, long x, long y, int zoom) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox(x, y, zoom);
        if (projection != null) {
            ProjectionTransform transform = webMercator.getTransformation(projection);
            boundingBox = transform.transform(boundingBox);
        }
        return boundingBox;
    }

    public static BoundingBox getProjectedBoundingBox(Long projectionEpsg, TileGrid tileGrid, int zoom) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox(tileGrid, zoom);
        if (projectionEpsg != null) {
            ProjectionTransform transform = webMercator.getTransformation(projectionEpsg);
            boundingBox = transform.transform(boundingBox);
        }
        return boundingBox;
    }

    public static BoundingBox getProjectedBoundingBox(Projection projection, TileGrid tileGrid, int zoom) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox(tileGrid, zoom);
        if (projection != null) {
            ProjectionTransform transform = webMercator.getTransformation(projection);
            boundingBox = transform.transform(boundingBox);
        }
        return boundingBox;
    }

    public static TileGrid getTileGridFromWGS84(Point point, int zoom) {
        Projection projection = ProjectionFactory.getProjection(4326L);
        return TileBoundingBoxUtils.getTileGrid(point, zoom, projection);
    }

    public static TileGrid getTileGrid(Point point, int zoom, Projection projection) {
        ProjectionTransform toWebMercator = projection.getTransformation(3857L);
        Point webMercatorPoint = toWebMercator.transform(point);
        BoundingBox boundingBox = new BoundingBox(webMercatorPoint.getX(), webMercatorPoint.getX(), webMercatorPoint.getY(), webMercatorPoint.getY());
        return TileBoundingBoxUtils.getTileGrid(boundingBox, zoom);
    }

    public static TileGrid getTileGrid(BoundingBox webMercatorBoundingBox, int zoom) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        double tileSize = TileBoundingBoxUtils.tileSize(tilesPerSide);
        int minX = (int)((webMercatorBoundingBox.getMinLongitude() + ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH) / tileSize);
        double tempMaxX = (webMercatorBoundingBox.getMaxLongitude() + ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH) / tileSize;
        int maxX = (int)(tempMaxX - ProjectionConstants.WEB_MERCATOR_PRECISION);
        maxX = Math.min(maxX, tilesPerSide - 1);
        int minY = (int)((webMercatorBoundingBox.getMaxLatitude() - ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH) * -1.0 / tileSize);
        double tempMaxY = (webMercatorBoundingBox.getMinLatitude() - ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH) * -1.0 / tileSize;
        int maxY = (int)(tempMaxY - ProjectionConstants.WEB_MERCATOR_PRECISION);
        maxY = Math.min(maxY, tilesPerSide - 1);
        TileGrid grid = new TileGrid(minX, maxX, minY, maxY);
        return grid;
    }

    public static BoundingBox toWebMercator(BoundingBox boundingBox) {
        double minLatitude = Math.max(boundingBox.getMinLatitude(), -85.05112877980659);
        double maxLatitude = Math.min(boundingBox.getMaxLatitude(), 85.0511287798066);
        Point lowerLeftPoint = new Point(false, false, boundingBox.getMinLongitude(), minLatitude);
        Point upperRightPoint = new Point(false, false, boundingBox.getMaxLongitude(), maxLatitude);
        ProjectionTransform toWebMercator = ProjectionFactory.getProjection(4326L).getTransformation(3857L);
        lowerLeftPoint = toWebMercator.transform(lowerLeftPoint);
        upperRightPoint = toWebMercator.transform(upperRightPoint);
        BoundingBox mercatorBox = new BoundingBox(lowerLeftPoint.getX(), upperRightPoint.getX(), lowerLeftPoint.getY(), upperRightPoint.getY());
        return mercatorBox;
    }

    public static double tileSize(int tilesPerSide) {
        return 2.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH / (double)tilesPerSide;
    }

    public static double zoomLevelOfTileSize(double tileSize) {
        double tilesPerSide = 2.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH / tileSize;
        double zoom = Math.log(tilesPerSide) / Math.log(2.0);
        return zoom;
    }

    public static double tileWidthDegrees(int tilesPerSide) {
        return 360.0 / (double)tilesPerSide;
    }

    public static double tileHeightDegrees(int tilesPerSide) {
        return 180.0 / (double)tilesPerSide;
    }

    public static int tilesPerSide(int zoom) {
        return (int)Math.pow(2.0, zoom);
    }

    public static int getYAsOppositeTileFormat(int zoom, int y) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        int oppositeY = tilesPerSide - y - 1;
        return oppositeY;
    }

    public static int zoomFromTilesPerSide(int tilesPerSide) {
        return (int)(Math.log(tilesPerSide) / Math.log(2.0));
    }

    public static TileGrid getTileGrid(BoundingBox totalBox, long matrixWidth, long matrixHeight, BoundingBox boundingBox) {
        long minColumn = TileBoundingBoxUtils.getTileColumn(totalBox, matrixWidth, boundingBox.getMinLongitude());
        long maxColumn = TileBoundingBoxUtils.getTileColumn(totalBox, matrixWidth, boundingBox.getMaxLongitude());
        if (minColumn < matrixWidth && maxColumn >= 0L) {
            if (minColumn < 0L) {
                minColumn = 0L;
            }
            if (maxColumn >= matrixWidth) {
                maxColumn = matrixWidth - 1L;
            }
        }
        long maxRow = TileBoundingBoxUtils.getTileRow(totalBox, matrixHeight, boundingBox.getMinLatitude());
        long minRow = TileBoundingBoxUtils.getTileRow(totalBox, matrixHeight, boundingBox.getMaxLatitude());
        if (minRow < matrixHeight && maxRow >= 0L) {
            if (minRow < 0L) {
                minRow = 0L;
            }
            if (maxRow >= matrixHeight) {
                maxRow = matrixHeight - 1L;
            }
        }
        TileGrid tileGrid = new TileGrid(minColumn, maxColumn, minRow, maxRow);
        return tileGrid;
    }

    public static long getTileColumn(BoundingBox totalBox, long matrixWidth, double longitude) {
        long tileId;
        double minX = totalBox.getMinLongitude();
        double maxX = totalBox.getMaxLongitude();
        if (longitude < minX) {
            tileId = -1L;
        } else if (longitude >= maxX) {
            tileId = matrixWidth;
        } else {
            double matrixWidthMeters = totalBox.getMaxLongitude() - totalBox.getMinLongitude();
            double tileWidth = matrixWidthMeters / (double)matrixWidth;
            tileId = (long)((longitude - minX) / tileWidth);
        }
        return tileId;
    }

    public static long getTileRow(BoundingBox totalBox, long matrixHeight, double latitude) {
        long tileId;
        double minY = totalBox.getMinLatitude();
        double maxY = totalBox.getMaxLatitude();
        if (latitude <= minY) {
            tileId = matrixHeight;
        } else if (latitude > maxY) {
            tileId = -1L;
        } else {
            double matrixHeightMeters = totalBox.getMaxLatitude() - totalBox.getMinLatitude();
            double tileHeight = matrixHeightMeters / (double)matrixHeight;
            tileId = (long)((maxY - latitude) / tileHeight);
        }
        return tileId;
    }

    public static BoundingBox getBoundingBox(BoundingBox totalBox, TileMatrix tileMatrix, long tileColumn, long tileRow) {
        return TileBoundingBoxUtils.getBoundingBox(totalBox, tileMatrix.getMatrixWidth(), tileMatrix.getMatrixHeight(), tileColumn, tileRow);
    }

    public static BoundingBox getBoundingBox(BoundingBox totalBox, long tileMatrixWidth, long tileMatrixHeight, long tileColumn, long tileRow) {
        TileGrid tileGrid = new TileGrid(tileColumn, tileColumn, tileRow, tileRow);
        return TileBoundingBoxUtils.getBoundingBox(totalBox, tileMatrixWidth, tileMatrixHeight, tileGrid);
    }

    public static BoundingBox getBoundingBox(BoundingBox totalBox, TileMatrix tileMatrix, TileGrid tileGrid) {
        return TileBoundingBoxUtils.getBoundingBox(totalBox, tileMatrix.getMatrixWidth(), tileMatrix.getMatrixHeight(), tileGrid);
    }

    public static BoundingBox getBoundingBox(BoundingBox totalBox, long tileMatrixWidth, long tileMatrixHeight, TileGrid tileGrid) {
        double matrixMinX = totalBox.getMinLongitude();
        double matrixMaxX = totalBox.getMaxLongitude();
        double matrixWidth = matrixMaxX - matrixMinX;
        double tileWidth = matrixWidth / (double)tileMatrixWidth;
        double minLon = matrixMinX + tileWidth * (double)tileGrid.getMinX();
        double maxLon = matrixMinX + tileWidth * (double)(tileGrid.getMaxX() + 1L);
        double matrixMinY = totalBox.getMinLatitude();
        double matrixMaxY = totalBox.getMaxLatitude();
        double matrixHeight = matrixMaxY - matrixMinY;
        double tileHeight = matrixHeight / (double)tileMatrixHeight;
        double maxLat = matrixMaxY - tileHeight * (double)tileGrid.getMinY();
        double minLat = matrixMaxY - tileHeight * (double)(tileGrid.getMaxY() + 1L);
        BoundingBox boundingBox = new BoundingBox(minLon, maxLon, minLat, maxLat);
        return boundingBox;
    }

    public static int getZoomLevel(BoundingBox webMercatorBoundingBox) {
        double worldLength = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH * 2.0;
        int widthTiles = (int)(worldLength / (webMercatorBoundingBox.getMaxLongitude() - webMercatorBoundingBox.getMinLongitude()));
        int heightTiles = (int)(worldLength / (webMercatorBoundingBox.getMaxLatitude() - webMercatorBoundingBox.getMinLatitude()));
        int tilesPerSide = Math.min(widthTiles, heightTiles);
        tilesPerSide = Math.max(tilesPerSide, 1);
        int zoom = TileBoundingBoxUtils.zoomFromTilesPerSide(tilesPerSide);
        return zoom;
    }

    public static double getPixelXSize(BoundingBox webMercatorBoundingBox, long matrixWidth, int tileWidth) {
        double pixelXSize = (webMercatorBoundingBox.getMaxLongitude() - webMercatorBoundingBox.getMinLongitude()) / (double)matrixWidth / (double)tileWidth;
        return pixelXSize;
    }

    public static double getPixelYSize(BoundingBox webMercatorBoundingBox, long matrixHeight, int tileHeight) {
        double pixelYSize = (webMercatorBoundingBox.getMaxLatitude() - webMercatorBoundingBox.getMinLatitude()) / (double)matrixHeight / (double)tileHeight;
        return pixelYSize;
    }

    public static BoundingBox boundWgs84BoundingBoxWithWebMercatorLimits(BoundingBox boundingBox) {
        BoundingBox bounded = new BoundingBox(boundingBox);
        if (bounded.getMinLatitude() < -85.05112877980659) {
            bounded.setMinLatitude(-85.05112877980659);
        }
        if (bounded.getMaxLatitude() > 85.0511287798066) {
            bounded.setMaxLatitude(85.0511287798066);
        }
        return bounded;
    }

    public static TileGrid getTileGridWGS84(BoundingBox boundingBox, int zoom) {
        int tilesPerLat = TileBoundingBoxUtils.tilesPerWGS84LatSide(zoom);
        int tilesPerLon = TileBoundingBoxUtils.tilesPerWGS84LonSide(zoom);
        double tileSizeLat = TileBoundingBoxUtils.tileSizeLatPerWGS84Side(tilesPerLat);
        double tileSizeLon = TileBoundingBoxUtils.tileSizeLonPerWGS84Side(tilesPerLon);
        int minX = (int)((boundingBox.getMinLongitude() + ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH) / tileSizeLon);
        double tempMaxX = (boundingBox.getMaxLongitude() + ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH) / tileSizeLon;
        int maxX = (int)tempMaxX;
        if (tempMaxX % 1.0 == 0.0) {
            --maxX;
        }
        maxX = Math.min(maxX, tilesPerLon - 1);
        int minY = (int)((boundingBox.getMaxLatitude() - ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT) * -1.0 / tileSizeLat);
        double tempMaxY = (boundingBox.getMinLatitude() - ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT) * -1.0 / tileSizeLat;
        int maxY = (int)tempMaxY;
        if (tempMaxY % 1.0 == 0.0) {
            --maxY;
        }
        maxY = Math.min(maxY, tilesPerLat - 1);
        TileGrid grid = new TileGrid(minX, maxX, minY, maxY);
        return grid;
    }

    public static BoundingBox getWGS84BoundingBox(TileGrid tileGrid, int zoom) {
        int tilesPerLat = TileBoundingBoxUtils.tilesPerWGS84LatSide(zoom);
        int tilesPerLon = TileBoundingBoxUtils.tilesPerWGS84LonSide(zoom);
        double tileSizeLat = TileBoundingBoxUtils.tileSizeLatPerWGS84Side(tilesPerLat);
        double tileSizeLon = TileBoundingBoxUtils.tileSizeLonPerWGS84Side(tilesPerLon);
        double minLon = -1.0 * ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH + (double)tileGrid.getMinX() * tileSizeLon;
        double maxLon = -1.0 * ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH + (double)(tileGrid.getMaxX() + 1L) * tileSizeLon;
        double minLat = ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT - (double)(tileGrid.getMaxY() + 1L) * tileSizeLat;
        double maxLat = ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT - (double)tileGrid.getMinY() * tileSizeLat;
        BoundingBox box = new BoundingBox(minLon, maxLon, minLat, maxLat);
        return box;
    }

    public static int tilesPerWGS84LatSide(int zoom) {
        return TileBoundingBoxUtils.tilesPerSide(zoom);
    }

    public static int tilesPerWGS84LonSide(int zoom) {
        return 2 * TileBoundingBoxUtils.tilesPerSide(zoom);
    }

    public static double tileSizeLatPerWGS84Side(int tilesPerLat) {
        return 2.0 * ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT / (double)tilesPerLat;
    }

    public static double tileSizeLonPerWGS84Side(int tilesPerLon) {
        return 2.0 * ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH / (double)tilesPerLon;
    }
}

