/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.projection.Projection;
import mil.nga.geopackage.projection.ProjectionTransform;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.user.ColumnValue;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserCoreConnection;
import mil.nga.geopackage.user.UserCoreResult;
import mil.nga.geopackage.user.UserCoreRow;
import mil.nga.geopackage.user.UserTable;

public abstract class UserCoreDao<TColumn extends UserColumn, TTable extends UserTable<TColumn>, TRow extends UserCoreRow<TColumn, TTable>, TResult extends UserCoreResult<TColumn, TTable, TRow>> {
    private final String database;
    private final GeoPackageCoreConnection db;
    private final UserCoreConnection<TColumn, TTable, TRow, TResult> userDb;
    private final TTable table;
    protected Projection projection;

    protected UserCoreDao(String database, GeoPackageCoreConnection db, UserCoreConnection<TColumn, TTable, TRow, TResult> userDb, TTable table) {
        this.database = database;
        this.db = db;
        this.userDb = userDb;
        this.table = table;
    }

    public abstract TRow newRow();

    public abstract BoundingBox getBoundingBox();

    public String getDatabase() {
        return this.database;
    }

    public GeoPackageCoreConnection getDb() {
        return this.db;
    }

    public UserCoreConnection<TColumn, TTable, TRow, TResult> getUserDb() {
        return this.userDb;
    }

    public String getTableName() {
        return ((UserTable)this.table).getTableName();
    }

    public TTable getTable() {
        return this.table;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void dropTable() {
        this.db.execSQL("DROP TABLE IF EXISTS " + this.getTableName());
    }

    public TResult queryForAll() {
        return this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), null, null, null, null, null);
    }

    public TResult queryForEq(String fieldName, Object value) {
        return this.queryForEq(fieldName, value, null, null, null);
    }

    public TResult queryForEq(String fieldName, Object value, String groupBy, String having, String orderBy) {
        String where = this.buildWhere(fieldName, value);
        String[] whereArgs = this.buildWhereArgs(value);
        return this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, groupBy, having, orderBy);
    }

    public TResult queryForEq(String fieldName, ColumnValue value) {
        String where = this.buildWhere(fieldName, value);
        String[] whereArgs = this.buildWhereArgs(value);
        return this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, null, null, null);
    }

    public TResult queryForFieldValues(Map<String, Object> fieldValues) {
        String where = this.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.buildWhereArgs(fieldValues.values());
        return this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, null, null, null);
    }

    public TResult queryForValueFieldValues(Map<String, ColumnValue> fieldValues) {
        String where = this.buildValueWhere(fieldValues.entrySet());
        String[] whereArgs = this.buildValueWhereArgs(fieldValues.values());
        return this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, null, null, null);
    }

    public TResult queryForId(long id) {
        String where = this.getPkWhere(id);
        String[] whereArgs = this.getPkWhereArgs(id);
        return this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, null, null, null);
    }

    public TRow queryForIdRow(long id) {
        TRow row = null;
        TResult readCursor = this.queryForId(id);
        if (readCursor.moveToNext()) {
            row = readCursor.getRow();
        }
        readCursor.close();
        return row;
    }

    public TResult query(String where, String[] whereArgs) {
        return this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, null, null, null);
    }

    public TResult query(String where, String[] whereArgs, String groupBy, String having, String orderBy) {
        return this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, groupBy, having, orderBy);
    }

    public TResult query(String where, String[] whereArgs, String groupBy, String having, String orderBy, String limit) {
        return this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, groupBy, having, orderBy, limit);
    }

    public abstract int update(TRow var1);

    public int delete(TRow row) {
        return this.deleteById(((UserCoreRow)row).getId());
    }

    public int deleteById(long id) {
        return this.db.delete(this.getTableName(), this.getPkWhere(id), this.getPkWhereArgs(id));
    }

    public int delete(String whereClause, String[] whereArgs) {
        return this.db.delete(this.getTableName(), whereClause, whereArgs);
    }

    public long create(TRow row) {
        return this.insert(row);
    }

    public abstract long insert(TRow var1);

    protected String getPkWhere(long id) {
        return this.buildWhere(((UserColumn)((UserTable)this.table).getPkColumn()).getName(), id);
    }

    protected String[] getPkWhereArgs(long id) {
        return this.buildWhereArgs(id);
    }

    public String buildWhere(Set<Map.Entry<String, Object>> fields) {
        StringBuilder selection = new StringBuilder();
        for (Map.Entry<String, Object> field : fields) {
            if (selection.length() > 0) {
                selection.append(" AND ");
            }
            selection.append(this.buildWhere(field.getKey(), field.getValue()));
        }
        return selection.toString();
    }

    public String buildValueWhere(Set<Map.Entry<String, ColumnValue>> fields) {
        StringBuilder selection = new StringBuilder();
        for (Map.Entry<String, ColumnValue> field : fields) {
            if (selection.length() > 0) {
                selection.append(" AND ");
            }
            selection.append(this.buildWhere(field.getKey(), field.getValue()));
        }
        return selection.toString();
    }

    public String buildWhere(String field, Object value) {
        return this.buildWhere(field, value, "=");
    }

    public String buildWhere(String field, Object value, String operation) {
        return "\"" + field + "\" " + (value != null ? operation + " ?" : "IS NULL");
    }

    public String buildWhere(String field, ColumnValue value) {
        String where;
        if (value != null) {
            if (value.getValue() != null && value.getTolerance() != null) {
                if (!(value.getValue() instanceof Number)) {
                    throw new GeoPackageException("Field value is not a number and can not use a tolerance, Field: " + field + ", Value: " + value);
                }
                where = "\"" + field + "\" >= ? AND \"" + field + "\" <= ?";
            } else {
                where = this.buildWhere(field, value.getValue());
            }
        } else {
            where = this.buildWhere(field, null, "=");
        }
        return where;
    }

    public String[] buildWhereArgs(Collection<Object> values) {
        ArrayList<String> selectionArgs = new ArrayList<String>();
        for (Object value : values) {
            if (value == null) continue;
            selectionArgs.add(value.toString());
        }
        return selectionArgs.isEmpty() ? null : selectionArgs.toArray(new String[0]);
    }

    public String[] buildWhereArgs(Object[] values) {
        ArrayList<String> selectionArgs = new ArrayList<String>();
        for (Object value : values) {
            if (value == null) continue;
            selectionArgs.add(value.toString());
        }
        return selectionArgs.isEmpty() ? null : selectionArgs.toArray(new String[0]);
    }

    public String[] buildValueWhereArgs(Collection<ColumnValue> values) {
        ArrayList<String> selectionArgs = new ArrayList<String>();
        for (ColumnValue value : values) {
            if (value == null || value.getValue() == null) continue;
            if (value.getTolerance() != null) {
                String[] toleranceArgs = this.getValueToleranceRange(value);
                selectionArgs.add(toleranceArgs[0]);
                selectionArgs.add(toleranceArgs[1]);
                continue;
            }
            selectionArgs.add(value.getValue().toString());
        }
        return selectionArgs.isEmpty() ? null : selectionArgs.toArray(new String[0]);
    }

    public String[] buildWhereArgs(Object value) {
        String[] args = null;
        if (value != null) {
            args = new String[]{value.toString()};
        }
        return args;
    }

    public String[] buildWhereArgs(ColumnValue value) {
        String[] args = null;
        if (value != null) {
            args = value.getValue() != null && value.getTolerance() != null ? this.getValueToleranceRange(value) : this.buildWhereArgs(value.getValue());
        }
        return args;
    }

    public int count() {
        return this.count(null, null);
    }

    public int count(String where, String[] args) {
        return this.db.count(this.getTableName(), where, args);
    }

    public Integer min(String column, String where, String[] args) {
        return this.db.min(this.getTableName(), column, where, args);
    }

    public Integer max(String column, String where, String[] args) {
        return this.db.max(this.getTableName(), column, where, args);
    }

    public int getZoomLevel() {
        Projection projection = this.getProjection();
        if (projection == null) {
            throw new GeoPackageException("No projection was set which is required to determine the zoom level");
        }
        BoundingBox boundingBox = this.getBoundingBox();
        ProjectionTransform webMercatorTransform = projection.getTransformation(3857L);
        BoundingBox webMercatorBoundingBox = webMercatorTransform.transform(boundingBox);
        int zoomLevel = TileBoundingBoxUtils.getZoomLevel(webMercatorBoundingBox);
        return zoomLevel;
    }

    private String[] getValueToleranceRange(ColumnValue value) {
        double doubleValue = ((Number)value.getValue()).doubleValue();
        double tolerance = value.getTolerance();
        return new String[]{Double.toString(doubleValue - tolerance), Double.toString(doubleValue + tolerance)};
    }
}

