/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.wkb.geom.GeometryType;

public class GeometryExtensions
extends BaseExtension {
    public static final String GEOMETRY_TYPES_EXTENSION_DEFINITION = GeoPackageProperties.getProperty("geopackage.extensions", "geometry_types");
    public static final String USER_GEOMETRY_TYPES_EXTENSION_DEFINITION = GeoPackageProperties.getProperty("geopackage.extensions", "user_geometry_types");

    public GeometryExtensions(GeoPackageCore geoPackage) {
        super(geoPackage);
    }

    public Extensions getOrCreate(String tableName, String columnName, GeometryType geometryType) {
        String extensionName = GeometryExtensions.getExtensionName(geometryType);
        Extensions extension = this.getOrCreate(extensionName, tableName, columnName, GEOMETRY_TYPES_EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        return extension;
    }

    public boolean has(String tableName, String columnName, GeometryType geometryType) {
        String extensionName = GeometryExtensions.getExtensionName(geometryType);
        boolean exists = this.has(extensionName, tableName, columnName);
        return exists;
    }

    public static boolean isExtension(GeometryType geometryType) {
        return geometryType.getCode() > GeometryType.GEOMETRYCOLLECTION.getCode();
    }

    public static boolean isGeoPackageExtension(GeometryType geometryType) {
        return geometryType.getCode() >= GeometryType.CIRCULARSTRING.getCode() && geometryType.getCode() <= GeometryType.SURFACE.getCode();
    }

    public static String getExtensionName(GeometryType geometryType) {
        if (!GeometryExtensions.isExtension(geometryType)) {
            throw new GeoPackageException(GeometryType.class.getSimpleName() + " is not an extension: " + geometryType.getName());
        }
        if (!GeometryExtensions.isGeoPackageExtension(geometryType)) {
            throw new GeoPackageException(GeometryType.class.getSimpleName() + " is not a GeoPackage extension, User-Defined requires an author: " + geometryType.getName());
        }
        String extensionName = "gpkg_geom_" + geometryType.getName();
        return extensionName;
    }

    public Extensions getOrCreate(String tableName, String columnName, String author, GeometryType geometryType) {
        String extensionName = GeometryExtensions.getExtensionName(author, geometryType);
        String description = GeometryExtensions.isGeoPackageExtension(geometryType) ? GEOMETRY_TYPES_EXTENSION_DEFINITION : USER_GEOMETRY_TYPES_EXTENSION_DEFINITION;
        Extensions extension = this.getOrCreate(extensionName, tableName, columnName, description, ExtensionScopeType.READ_WRITE);
        return extension;
    }

    public boolean has(String tableName, String columnName, String author, GeometryType geometryType) {
        String extensionName = GeometryExtensions.getExtensionName(author, geometryType);
        boolean exists = this.has(extensionName, tableName, columnName);
        return exists;
    }

    public static String getExtensionName(String author, GeometryType geometryType) {
        if (!GeometryExtensions.isExtension(geometryType)) {
            throw new GeoPackageException(GeometryType.class.getSimpleName() + " is not an extension: " + geometryType.getName());
        }
        String extensionName = (GeometryExtensions.isGeoPackageExtension(geometryType) ? "gpkg" : author) + "_" + "geom" + "_" + geometryType.getName();
        return extensionName;
    }
}

