/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.index.FeatureTableCoreIndex;
import mil.nga.geopackage.extension.index.GeometryIndex;
import mil.nga.geopackage.extension.index.GeometryIndexDao;
import mil.nga.geopackage.extension.index.TableIndex;
import mil.nga.geopackage.extension.index.TableIndexDao;
import mil.nga.geopackage.extension.link.FeatureTileLink;
import mil.nga.geopackage.extension.link.FeatureTileLinkDao;
import mil.nga.geopackage.extension.link.FeatureTileTableCoreLinker;

public class NGAExtensions {
    public static void deleteTableExtensions(GeoPackageCore geoPackage, String table) {
        NGAExtensions.deleteGeometryIndex(geoPackage, table);
        NGAExtensions.deleteFeatureTileLink(geoPackage, table);
    }

    public static void deleteExtensions(GeoPackageCore geoPackage) {
        NGAExtensions.deleteExtensions(geoPackage, false);
    }

    public static void deleteExtensions(GeoPackageCore geoPackage, boolean ignoreErrors) {
        NGAExtensions.deleteGeometryIndexExtension(geoPackage, ignoreErrors);
        NGAExtensions.deleteFeatureTileLinkExtension(geoPackage, ignoreErrors);
    }

    public static void deleteGeometryIndex(GeoPackageCore geoPackage, String table) {
        TableIndexDao tableIndexDao = geoPackage.getTableIndexDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (tableIndexDao.isTableExists()) {
                tableIndexDao.deleteByIdCascade(table);
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(FeatureTableCoreIndex.EXTENSION_NAME, table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table Index. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public static void deleteGeometryIndexExtension(GeoPackageCore geoPackage, boolean ignoreErrors) {
        GeometryIndexDao geometryIndexDao = geoPackage.getGeometryIndexDao();
        TableIndexDao tableIndexDao = geoPackage.getTableIndexDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        ConnectionSource connectionSource = geoPackage.getDatabase().getConnectionSource();
        try {
            if (geometryIndexDao.isTableExists()) {
                TableUtils.dropTable((ConnectionSource)connectionSource, GeometryIndex.class, (boolean)ignoreErrors);
            }
            if (tableIndexDao.isTableExists()) {
                TableUtils.dropTable((ConnectionSource)connectionSource, TableIndex.class, (boolean)ignoreErrors);
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(FeatureTableCoreIndex.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table Index extension and tables. GeoPackage: " + geoPackage.getName(), e);
        }
    }

    public static void deleteFeatureTileLink(GeoPackageCore geoPackage, String table) {
        FeatureTileLinkDao featureTileLinkDao = geoPackage.getFeatureTileLinkDao();
        try {
            if (featureTileLinkDao.isTableExists()) {
                featureTileLinkDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Feature Tile Link. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public static void deleteFeatureTileLinkExtension(GeoPackageCore geoPackage, boolean ignoreErrors) {
        FeatureTileLinkDao featureTileLinkDao = geoPackage.getFeatureTileLinkDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        ConnectionSource connectionSource = geoPackage.getDatabase().getConnectionSource();
        try {
            if (featureTileLinkDao.isTableExists()) {
                TableUtils.dropTable((ConnectionSource)connectionSource, FeatureTileLink.class, (boolean)ignoreErrors);
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(FeatureTileTableCoreLinker.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Feature Tile Link extension and table. GeoPackage: " + geoPackage.getName(), e);
        }
    }
}

