/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.projection;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.projection.AuthorityProjections;
import mil.nga.geopackage.projection.Projection;
import mil.nga.geopackage.projection.ProjectionRetriever;
import org.osgeo.proj4j.CRSFactory;
import org.osgeo.proj4j.CoordinateReferenceSystem;

public class ProjectionFactory {
    private static final Logger logger = Logger.getLogger(ProjectionFactory.class.getName());
    private static final CRSFactory csFactory = new CRSFactory();
    private static Map<String, AuthorityProjections> authorities = new HashMap<String, AuthorityProjections>();

    public static Projection getProjection(long epsg) {
        return ProjectionFactory.getProjection("EPSG", String.valueOf(epsg));
    }

    public static Projection getProjection(String authority, long code) {
        return ProjectionFactory.getProjection(authority, String.valueOf(code));
    }

    public static Projection getProjection(String authority, String code) {
        return ProjectionFactory.getProjection(authority, code, null, null);
    }

    public static Projection getProjection(String authority, long code, String paramStr) {
        return ProjectionFactory.getProjection(authority, String.valueOf(code), paramStr);
    }

    public static Projection getProjection(String authority, String code, String paramStr) {
        String[] params = null;
        if (paramStr != null && !paramStr.isEmpty()) {
            params = paramStr.split("\\s+");
        }
        Projection projection = ProjectionFactory.getProjection(authority, code, params);
        return projection;
    }

    public static Projection getProjection(String authority, long code, String[] params) {
        return ProjectionFactory.getProjection(authority, String.valueOf(code), params);
    }

    public static Projection getProjection(String authority, String code, String[] params) {
        return ProjectionFactory.getProjection(authority, code, params, null);
    }

    public static Projection getProjection(String authority, long code, String[] params, String definition) {
        return ProjectionFactory.getProjection(authority, String.valueOf(code), params, definition);
    }

    public static Projection getProjection(String authority, String code, String[] params, String definition) {
        AuthorityProjections authorityProjections = ProjectionFactory.getProjections(authority);
        Projection projection = authorityProjections.getProjection(code);
        if (projection == null && (projection = ProjectionFactory.fromDefinition(authorityProjections, code, definition)) == null && (projection = ProjectionFactory.fromParams(authorityProjections, code, params)) == null && (projection = ProjectionFactory.fromProperties(authorityProjections, code)) == null && (projection = ProjectionFactory.fromName(authorityProjections, code)) == null) {
            throw new GeoPackageException("Failed to create projection for authority: " + authority + ", code: " + code + ", definition: " + definition + ", params: " + Arrays.toString(params));
        }
        return projection;
    }

    public static AuthorityProjections getProjections(String authority) {
        AuthorityProjections authorityProjections = authorities.get(authority.toUpperCase());
        if (authorityProjections == null) {
            authorityProjections = new AuthorityProjections(authority);
            authorities.put(authority.toUpperCase(), authorityProjections);
        }
        return authorityProjections;
    }

    public static void clear() {
        authorities.clear();
    }

    public static void clear(String authority) {
        ProjectionFactory.getProjections(authority).clear();
    }

    public static void clear(String authority, long code) {
        ProjectionFactory.getProjections(authority).clear(code);
    }

    public static void clear(String authority, String code) {
        ProjectionFactory.getProjections(authority).clear(code);
    }

    private static Projection fromDefinition(AuthorityProjections authorityProjections, String code, String definition) {
        String parametersString;
        Projection projection = null;
        if (definition != null && !definition.isEmpty() && (parametersString = "") != null && !parametersString.isEmpty()) {
            try {
                CoordinateReferenceSystem crs = csFactory.createFromParameters(ProjectionFactory.coordinateName(authorityProjections.getAuthority(), code), parametersString);
                projection = new Projection(authorityProjections.getAuthority(), code, crs);
                authorityProjections.addProjection(projection);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create projection for authority: " + authorityProjections.getAuthority() + ", code: " + code + ", definition: " + definition + ", parameters: " + parametersString, e);
            }
        }
        return projection;
    }

    private static Projection fromParams(AuthorityProjections authorityProjections, String code, String[] params) {
        Projection projection = null;
        if (params != null && params.length > 0) {
            try {
                CoordinateReferenceSystem crs = csFactory.createFromParameters(ProjectionFactory.coordinateName(authorityProjections.getAuthority(), code), params);
                projection = new Projection(authorityProjections.getAuthority(), code, crs);
                authorityProjections.addProjection(projection);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create projection for authority: " + authorityProjections.getAuthority() + ", code: " + code + ", parameters: " + Arrays.toString(params), e);
            }
        }
        return projection;
    }

    private static Projection fromProperties(AuthorityProjections authorityProjections, String code) {
        Projection projection = null;
        String parameters = ProjectionRetriever.getProjection(authorityProjections.getAuthority(), code);
        if (parameters != null && !parameters.isEmpty()) {
            try {
                CoordinateReferenceSystem crs = csFactory.createFromParameters(ProjectionFactory.coordinateName(authorityProjections.getAuthority(), code), parameters);
                projection = new Projection(authorityProjections.getAuthority(), code, crs);
                authorityProjections.addProjection(projection);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create projection for authority: " + authorityProjections.getAuthority() + ", code: " + code + ", parameters: " + parameters, e);
            }
        }
        return projection;
    }

    private static Projection fromName(AuthorityProjections authorityProjections, String code) {
        Projection projection = null;
        String name = ProjectionFactory.coordinateName(authorityProjections.getAuthority(), code);
        try {
            CoordinateReferenceSystem crs = csFactory.createFromName(name);
            projection = new Projection(authorityProjections.getAuthority(), code, crs);
            authorityProjections.addProjection(projection);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create projection from name: " + name, e);
        }
        return projection;
    }

    private static String coordinateName(String authority, String code) {
        return authority.toUpperCase() + ":" + code;
    }

    public static Projection getProjection(SpatialReferenceSystem srs) {
        String authority = srs.getOrganization();
        long code = srs.getOrganizationCoordsysId();
        String definition = srs.getDefinition_12_063();
        if (definition == null) {
            definition = srs.getDefinition();
        }
        Projection projection = ProjectionFactory.getProjection(authority, code, null, definition);
        return projection;
    }
}

