/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.projection;

import java.lang.reflect.Field;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.projection.ProjectionFactory;
import mil.nga.geopackage.projection.ProjectionTransform;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.units.Unit;
import org.osgeo.proj4j.units.Units;

public class Projection {
    private final String authority;
    private final String code;
    private final CoordinateReferenceSystem crs;

    public Projection(String authority, long code, CoordinateReferenceSystem crs) {
        this(authority, String.valueOf(code), crs);
    }

    public Projection(String authority, String code, CoordinateReferenceSystem crs) {
        if (authority == null || code == null || crs == null) {
            throw new IllegalArgumentException("All projection arguments are required. authority: " + authority + ", code: " + code + ", crs: " + crs);
        }
        this.authority = authority;
        this.code = code;
        this.crs = crs;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getCode() {
        return this.code;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public ProjectionTransform getTransformation(long epsg) {
        return this.getTransformation("EPSG", epsg);
    }

    public ProjectionTransform getTransformation(String authority, long code) {
        Projection projectionTo = ProjectionFactory.getProjection(authority, code);
        return this.getTransformation(projectionTo);
    }

    public ProjectionTransform getTransformation(SpatialReferenceSystem srs) {
        Projection projectionTo = ProjectionFactory.getProjection(srs);
        return this.getTransformation(projectionTo);
    }

    public ProjectionTransform getTransformation(Projection projection) {
        return new ProjectionTransform(this, projection);
    }

    public double toMeters(double value) {
        return value / this.crs.getProjection().getFromMetres();
    }

    public Unit getUnit() {
        Unit unit = null;
        try {
            Field f = org.osgeo.proj4j.proj.Projection.class.getDeclaredField("unit");
            f.setAccessible(true);
            unit = (Unit)f.get(this.crs.getProjection());
            if (unit == null) {
                unit = Units.METRES;
            }
        }
        catch (Exception e) {
            throw new GeoPackageException("Failed to get projection unit for authority: " + this.authority + ", code: " + this.code, e);
        }
        return unit;
    }

    public boolean equals(String authority, long code) {
        return this.equals(authority, String.valueOf(code));
    }

    public boolean equals(String authority, String code) {
        return this.authority.equals(authority) && this.code.equals(code);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.authority.hashCode();
        result = 31 * result + this.code.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Projection other = (Projection)obj;
        return this.equals(other.authority, other.code);
    }
}

