/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.matrixset;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSetDao;

@DatabaseTable(tableName="gpkg_tile_matrix_set", daoClass=TileMatrixSetDao.class)
public class TileMatrixSet {
    public static final String TABLE_NAME = "gpkg_tile_matrix_set";
    public static final String COLUMN_TABLE_NAME = "table_name";
    public static final String COLUMN_ID = "table_name";
    public static final String COLUMN_SRS_ID = "srs_id";
    public static final String COLUMN_MIN_X = "min_x";
    public static final String COLUMN_MIN_Y = "min_y";
    public static final String COLUMN_MAX_X = "max_x";
    public static final String COLUMN_MAX_Y = "max_y";
    @DatabaseField(columnName="table_name", canBeNull=false, foreign=true, foreignAutoRefresh=true)
    private Contents contents;
    @DatabaseField(columnName="table_name", id=true, canBeNull=false)
    private String tableName;
    @DatabaseField(columnName="srs_id", canBeNull=false, foreign=true, foreignAutoRefresh=true)
    private SpatialReferenceSystem srs;
    @DatabaseField(columnName="srs_id", canBeNull=false)
    private long srsId;
    @DatabaseField(columnName="min_x", canBeNull=false)
    private double minX;
    @DatabaseField(columnName="min_y", canBeNull=false)
    private double minY;
    @DatabaseField(columnName="max_x", canBeNull=false)
    private double maxX;
    @DatabaseField(columnName="max_y", canBeNull=false)
    private double maxY;

    public TileMatrixSet() {
    }

    public TileMatrixSet(TileMatrixSet tileMatrixSet) {
        this.contents = tileMatrixSet.contents;
        this.tableName = tileMatrixSet.tableName;
        this.srs = tileMatrixSet.srs;
        this.srsId = tileMatrixSet.srsId;
        this.minX = tileMatrixSet.minX;
        this.minY = tileMatrixSet.minY;
        this.maxX = tileMatrixSet.maxX;
        this.maxY = tileMatrixSet.maxY;
    }

    public String getId() {
        return this.tableName;
    }

    public void setId(String id) {
        this.tableName = id;
    }

    public Contents getContents() {
        return this.contents;
    }

    public void setContents(Contents contents) {
        this.contents = contents;
        if (contents != null) {
            ContentsDataType dataType = contents.getDataType();
            if (dataType == null || dataType != ContentsDataType.TILES && dataType != ContentsDataType.ELEVATION_TILES) {
                throw new GeoPackageException("The " + Contents.class.getSimpleName() + " of a " + TileMatrixSet.class.getSimpleName() + " must have a data type of " + ContentsDataType.TILES.getName() + " or " + ContentsDataType.ELEVATION_TILES.getName());
            }
            this.tableName = contents.getId();
        } else {
            this.tableName = null;
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public SpatialReferenceSystem getSrs() {
        return this.srs;
    }

    public void setSrs(SpatialReferenceSystem srs) {
        this.srs = srs;
        this.srsId = srs != null ? srs.getId() : -1L;
    }

    public long getSrsId() {
        return this.srsId;
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public BoundingBox getBoundingBox() {
        BoundingBox boundingBox = new BoundingBox(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY());
        return boundingBox;
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.setMinX(boundingBox.getMinLongitude());
        this.setMaxX(boundingBox.getMaxLongitude());
        this.setMinY(boundingBox.getMinLatitude());
        this.setMaxY(boundingBox.getMaxLatitude());
    }
}

