/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.Arrays;
import java.util.Date;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;

public abstract class UserCoreRow<TColumn extends UserColumn, TTable extends UserTable<TColumn>> {
    protected final TTable table;
    protected final int[] columnTypes;
    protected final Object[] values;

    protected UserCoreRow(TTable table, int[] columnTypes, Object[] values) {
        this.table = table;
        this.columnTypes = columnTypes;
        this.values = values;
    }

    protected UserCoreRow(TTable table) {
        this.table = table;
        this.columnTypes = new int[((UserTable)table).columnCount()];
        this.values = new Object[((UserTable)table).columnCount()];
    }

    protected UserCoreRow(UserCoreRow<TColumn, TTable> userCoreRow) {
        this.table = userCoreRow.table;
        this.columnTypes = userCoreRow.columnTypes;
        this.values = new Object[userCoreRow.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            Object value = userCoreRow.values[i];
            if (value == null) continue;
            TColumn column = userCoreRow.getColumn(i);
            this.values[i] = this.copyValue(column, value);
        }
    }

    protected Object copyValue(TColumn column, Object value) {
        Object copyValue = value;
        switch (((UserColumn)column).getDataType()) {
            case BLOB: {
                if (value instanceof byte[]) {
                    byte[] bytes = (byte[])value;
                    copyValue = Arrays.copyOf(bytes, bytes.length);
                    break;
                }
                throw new GeoPackageException("Unsupported copy value type. column: " + ((UserColumn)column).getName() + ", value type: " + value.getClass().getName() + ", data type: " + (Object)((Object)((UserColumn)column).getDataType()));
            }
            case DATE: 
            case DATETIME: {
                if (value instanceof Date) {
                    Date date = (Date)value;
                    copyValue = new Date(date.getTime());
                    break;
                }
                if (value instanceof String) break;
                throw new GeoPackageException("Unsupported copy value type. column: " + ((UserColumn)column).getName() + ", value type: " + value.getClass().getName() + ", data type: " + (Object)((Object)((UserColumn)column).getDataType()));
            }
        }
        return copyValue;
    }

    public int columnCount() {
        return ((UserTable)this.table).columnCount();
    }

    public String[] getColumnNames() {
        return ((UserTable)this.table).getColumnNames();
    }

    public String getColumnName(int index) {
        return ((UserTable)this.table).getColumnName(index);
    }

    public int getColumnIndex(String columnName) {
        return ((UserTable)this.table).getColumnIndex(columnName);
    }

    public Object getValue(int index) {
        return this.values[index];
    }

    public Object getValue(String columnName) {
        return this.values[((UserTable)this.table).getColumnIndex(columnName)];
    }

    public Object[] getValues() {
        return this.values;
    }

    public int[] getRowColumnTypes() {
        return this.columnTypes;
    }

    public int getRowColumnType(int index) {
        return this.columnTypes[index];
    }

    public int getRowColumnType(String columnName) {
        return this.columnTypes[((UserTable)this.table).getColumnIndex(columnName)];
    }

    public TTable getTable() {
        return this.table;
    }

    public TColumn getColumn(int index) {
        return ((UserTable)this.table).getColumn(index);
    }

    public TColumn getColumn(String columnName) {
        return ((UserTable)this.table).getColumn(columnName);
    }

    public long getId() {
        Object objectValue = this.getValue(this.getPkColumnIndex());
        if (objectValue == null) {
            throw new GeoPackageException("Row Id was null. Table: " + ((UserTable)this.table).getTableName() + ", Column Index: " + this.getPkColumnIndex() + ", Column Name: " + ((UserColumn)this.getPkColumn()).getName());
        }
        if (!(objectValue instanceof Number)) {
            throw new GeoPackageException("Row Id was not a number. Table: " + ((UserTable)this.table).getTableName() + ", Column Index: " + this.getPkColumnIndex() + ", Column Name: " + ((UserColumn)this.getPkColumn()).getName());
        }
        long id = ((Number)objectValue).longValue();
        return id;
    }

    public int getPkColumnIndex() {
        return ((UserTable)this.table).getPkColumnIndex();
    }

    public TColumn getPkColumn() {
        return ((UserTable)this.table).getPkColumn();
    }

    public void setValue(int index, Object value) {
        if (index == ((UserTable)this.table).getPkColumnIndex()) {
            throw new GeoPackageException("Can not update the primary key of the row. Table Name: " + ((UserTable)this.table).getTableName() + ", Index: " + index + ", Name: " + ((UserColumn)((UserTable)this.table).getPkColumn()).getName());
        }
        this.values[index] = value;
    }

    public void setValue(String columnName, Object value) {
        this.setValue(this.getColumnIndex(columnName), value);
    }

    void setId(long id) {
        this.values[this.getPkColumnIndex()] = id;
    }

    public void resetId() {
        this.values[this.getPkColumnIndex()] = null;
    }

    protected void validateValue(TColumn column, Object value, Class<?> ... valueTypes) {
        GeoPackageDataType dataType = ((UserColumn)column).getDataType();
        Class<?> dataTypeClass = dataType.getClassType();
        boolean valid = false;
        for (Class<?> valueType : valueTypes) {
            if (!valueType.equals(dataTypeClass)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw new GeoPackageException("Illegal value. Column: " + ((UserColumn)column).getName() + ", Value: " + value + ", Expected Type: " + dataTypeClass.getSimpleName() + ", Actual Type: " + valueTypes[0].getSimpleName());
        }
    }
}

