/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemDao;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.io.ResourceIOUtils;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;
import mil.nga.geopackage.user.UserUniqueConstraint;

public class GeoPackageTableCreator {
    private final GeoPackageCoreConnection db;

    public GeoPackageTableCreator(GeoPackageCoreConnection db) {
        this.db = db;
    }

    public int createSpatialReferenceSystem() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "spatial_reference_system"));
    }

    public int createContents() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "contents"));
    }

    public int createGeometryColumns() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "geometry_columns"));
    }

    public int createTileMatrixSet() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "tile_matrix_set"));
    }

    public int createTileMatrix() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "tile_matrix"));
    }

    public int createDataColumns() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "data_columns"));
    }

    public int createDataColumnConstraints() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "data_column_constraints"));
    }

    public int createMetadata() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "metadata"));
    }

    public int createMetadataReference() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "metadata_reference"));
    }

    public int createExtensions() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "extensions"));
    }

    public int createGriddedCoverage() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "2d_gridded_coverage"));
    }

    public int createGriddedTile() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "2d_gridded_tile"));
    }

    public int createTableIndex() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "table_index"));
    }

    public int createGeometryIndex() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "geometry_index"));
    }

    public int createFeatureTileLink() {
        return this.createTable(GeoPackageProperties.getProperty("sql", "feature_tile_link"));
    }

    private int createTable(String tableScript) {
        String path = GeoPackageProperties.getProperty("sql", "directory");
        List<String> statements = ResourceIOUtils.parseSQLStatements(path, tableScript);
        for (String statement : statements) {
            this.db.execSQL(statement);
        }
        return statements.size();
    }

    public <TColumn extends UserColumn> void createTable(UserTable<TColumn> table) {
        if (this.db.tableExists(table.getTableName())) {
            throw new GeoPackageException("Table already exists and can not be created: " + table.getTableName());
        }
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ").append(CoreSQLUtils.quoteWrap(table.getTableName())).append(" (");
        List<TColumn> columns = table.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            UserColumn column = (UserColumn)columns.get(i);
            if (i > 0) {
                sql.append(",");
            }
            sql.append("\n  ").append(CoreSQLUtils.quoteWrap(column.getName())).append(" ").append(column.getTypeName());
            if (column.getMax() != null) {
                sql.append("(").append(column.getMax()).append(")");
            }
            if (column.isNotNull()) {
                sql.append(" NOT NULL");
            }
            if (!column.isPrimaryKey()) continue;
            sql.append(" PRIMARY KEY AUTOINCREMENT");
        }
        List<UserUniqueConstraint<TColumn>> uniqueConstraints = table.getUniqueConstraints();
        for (int i = 0; i < uniqueConstraints.size(); ++i) {
            UserUniqueConstraint<TColumn> uniqueConstraint = uniqueConstraints.get(i);
            sql.append(",\n  UNIQUE (");
            List<TColumn> uniqueColumns = uniqueConstraint.getColumns();
            for (int j = 0; j < uniqueColumns.size(); ++j) {
                UserColumn uniqueColumn = (UserColumn)uniqueColumns.get(j);
                if (j > 0) {
                    sql.append(", ");
                }
                sql.append(uniqueColumn.getName());
            }
            sql.append(")");
        }
        sql.append("\n);");
        this.db.execSQL(sql.toString());
    }

    public void createRequired() {
        this.createSpatialReferenceSystem();
        this.createContents();
        try {
            SpatialReferenceSystemDao dao = (SpatialReferenceSystemDao)DaoManager.createDao((ConnectionSource)this.db.getConnectionSource(), SpatialReferenceSystem.class);
            dao.createWgs84();
            dao.createUndefinedCartesian();
            dao.createUndefinedGeographic();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Error creating default required Spatial Reference Systems", e);
        }
    }

    public void dropTable(String table) {
        this.db.execSQL("DROP TABLE IF EXISTS " + CoreSQLUtils.quoteWrap(table));
    }
}

