/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.projection;

import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.projection.GeometryProjectionTransform;
import mil.nga.geopackage.projection.Projection;
import mil.nga.wkb.geom.Geometry;
import mil.nga.wkb.geom.Point;
import org.osgeo.proj4j.CoordinateTransform;
import org.osgeo.proj4j.CoordinateTransformFactory;
import org.osgeo.proj4j.ProjCoordinate;

public class ProjectionTransform {
    private static CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();
    private final Projection fromProjection;
    private final Projection toProjection;
    private final CoordinateTransform transform;

    ProjectionTransform(Projection fromProjection, Projection toProjection) {
        this.fromProjection = fromProjection;
        this.toProjection = toProjection;
        this.transform = ctFactory.createTransform(fromProjection.getCrs(), toProjection.getCrs());
    }

    public ProjCoordinate transform(ProjCoordinate from) {
        ProjCoordinate to = new ProjCoordinate();
        this.transform.transform(from, to);
        return to;
    }

    public Point transform(Point from) {
        GeometryProjectionTransform geometryTransform = new GeometryProjectionTransform(this);
        Point to = geometryTransform.transform(from);
        return to;
    }

    public List<Point> transform(List<Point> from) {
        ArrayList<Point> to = new ArrayList<Point>();
        GeometryProjectionTransform geometryTransform = new GeometryProjectionTransform(this);
        for (Point fromPoint : from) {
            Point toPoint = geometryTransform.transform(fromPoint);
            to.add(toPoint);
        }
        return to;
    }

    public Geometry transform(Geometry from) {
        GeometryProjectionTransform geometryTransform = new GeometryProjectionTransform(this);
        Geometry to = geometryTransform.transform(from);
        return to;
    }

    public BoundingBox transform(BoundingBox boundingBox) {
        ProjCoordinate lowerLeft = new ProjCoordinate(boundingBox.getMinLongitude(), boundingBox.getMinLatitude());
        ProjCoordinate lowerRight = new ProjCoordinate(boundingBox.getMaxLongitude(), boundingBox.getMinLatitude());
        ProjCoordinate upperRight = new ProjCoordinate(boundingBox.getMaxLongitude(), boundingBox.getMaxLatitude());
        ProjCoordinate upperLeft = new ProjCoordinate(boundingBox.getMinLongitude(), boundingBox.getMaxLatitude());
        ProjCoordinate projectedLowerLeft = this.transform(lowerLeft);
        ProjCoordinate projectedLowerRight = this.transform(lowerRight);
        ProjCoordinate projectedUpperRight = this.transform(upperRight);
        ProjCoordinate projectedUpperLeft = this.transform(upperLeft);
        double minX = Math.min(projectedLowerLeft.x, projectedUpperLeft.x);
        double maxX = Math.max(projectedLowerRight.x, projectedUpperRight.x);
        double minY = Math.min(projectedLowerLeft.y, projectedLowerRight.y);
        double maxY = Math.max(projectedUpperLeft.y, projectedUpperRight.y);
        BoundingBox projectedBoundingBox = new BoundingBox(minX, minY, maxX, maxY);
        return projectedBoundingBox;
    }

    public double[] transform(double x, double y) {
        ProjCoordinate fromCoord = new ProjCoordinate(x, y);
        ProjCoordinate toCoord = this.transform(fromCoord);
        return new double[]{toCoord.x, toCoord.y};
    }

    public Projection getFromProjection() {
        return this.fromProjection;
    }

    public Projection getToProjection() {
        return this.toProjection;
    }

    public CoordinateTransform getTransform() {
        return this.transform;
    }
}

