/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserCoreConnection;
import mil.nga.geopackage.user.UserCoreResult;
import mil.nga.geopackage.user.UserCoreRow;
import mil.nga.geopackage.user.UserTable;

public abstract class UserCoreTableReader<TColumn extends UserColumn, TTable extends UserTable<TColumn>, TRow extends UserCoreRow<TColumn, TTable>, TResult extends UserCoreResult<TColumn, TTable, TRow>> {
    private static final Logger logger = Logger.getLogger(UserCoreTableReader.class.getName());
    private static final String CID = "cid";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String NOT_NULL = "notnull";
    private static final String PK = "pk";
    private static final String DFLT_VALUE = "dflt_value";
    private final String tableName;

    protected UserCoreTableReader(String tableName) {
        this.tableName = tableName;
    }

    protected abstract TTable createTable(String var1, List<TColumn> var2);

    protected abstract TColumn createColumn(TResult var1, int var2, String var3, String var4, Long var5, boolean var6, int var7, boolean var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TTable readTable(UserCoreConnection<TColumn, TTable, TRow, TResult> db) {
        ArrayList<TColumn> columnList = new ArrayList<TColumn>();
        try (TResult result = db.rawQuery("PRAGMA table_info(" + CoreSQLUtils.quoteWrap(this.tableName) + ")", null);){
            while (result.moveToNext()) {
                String maxString;
                int maxStart;
                int index = result.getInt(result.getColumnIndex(CID));
                String name = result.getString(result.getColumnIndex(NAME));
                String type = result.getString(result.getColumnIndex(TYPE));
                boolean notNull = result.getInt(result.getColumnIndex(NOT_NULL)) == 1;
                boolean primaryKey = result.getInt(result.getColumnIndex(PK)) == 1;
                Long max = null;
                if (type != null && type.endsWith(")") && (maxStart = type.indexOf("(")) > -1 && !(maxString = type.substring(maxStart + 1, type.length() - 1)).isEmpty()) {
                    try {
                        max = Long.valueOf(maxString);
                        type = type.substring(0, maxStart);
                    }
                    catch (NumberFormatException e) {
                        logger.log(Level.WARNING, "Failed to parse type max from type: " + type, e);
                    }
                }
                int defaultValueIndex = result.getColumnIndex(DFLT_VALUE);
                TColumn column = this.createColumn(result, index, name, type, max, notNull, defaultValueIndex, primaryKey);
                columnList.add(column);
            }
        }
        if (columnList.isEmpty()) {
            throw new GeoPackageException("Table does not exist: " + this.tableName);
        }
        return this.createTable(this.tableName, columnList);
    }
}

