package mil.nga.geopackage.user;

import java.util.ArrayList;
import java.util.List;

/**
 * User table unique constraint for one or more columns
 * 
 * @param <TColumn>
 *            column type
 * 
 * @author osbornb
 */
public class UserUniqueConstraint<TColumn extends UserColumn> {

	/**
	 * Columns included in the unique constraint
	 */
	private final List<TColumn> columns = new ArrayList<TColumn>();

	/**
	 * Constructor
	 */
	public UserUniqueConstraint() {

	}

	/**
	 * Constructor
	 * 
	 * @param columns
	 *            columns
	 */
	public UserUniqueConstraint(
			@SuppressWarnings("unchecked") TColumn... columns) {
		for (TColumn column : columns) {
			add(column);
		}
	}

	/**
	 * Add a column
	 * 
	 * @param column
	 *            column
	 */
	public void add(TColumn column) {
		columns.add(column);
	}

	/**
	 * Get the columns
	 * 
	 * @return columns
	 */
	public List<TColumn> getColumns() {
		return columns;
	}

}
