/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import java.sql.SQLException;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.io.ResourceIOUtils;
import mil.nga.geopackage.property.GeoPackageProperties;

public abstract class RTreeIndexCoreExtension
extends BaseExtension {
    public static final String NAME = "rtree_index";
    public static final String MIN_X_FUNCTION = "ST_MinX";
    public static final String MAX_X_FUNCTION = "ST_MaxX";
    public static final String MIN_Y_FUNCTION = "ST_MinY";
    public static final String MAX_Y_FUNCTION = "ST_MaxY";
    public static final String IS_EMPTY_FUNCTION = "ST_IsEmpty";
    public static final String CREATE_PROPERTY = "create";
    public static final String LOAD_PROPERTY = "load";
    public static final String DROP_PROPERTY = "drop";
    public static final String TRIGGER_INSERT_NAME = "insert";
    public static final String TRIGGER_UPDATE1_NAME = "update1";
    public static final String TRIGGER_UPDATE2_NAME = "update2";
    public static final String TRIGGER_UPDATE3_NAME = "update3";
    public static final String TRIGGER_UPDATE4_NAME = "update4";
    public static final String TRIGGER_DELETE_NAME = "delete";
    public static final String TRIGGER_DROP_PROPERTY = "drop";
    public static final String EXTENSION_NAME = "gpkg_rtree_index";
    private static final String EXTENSION_PROPERTY = "geopackage.extensions.rtree_index";
    public static final String DEFINITION = GeoPackageProperties.getProperty("geopackage.extensions.rtree_index");
    private static final String SQL_PROPERTY = "geopackage.extensions.rtree_index.sql";
    private static final String SUBSTITUTE_PROPERTY = "geopackage.extensions.rtree_index.sql.substitute";
    private static final String TRIGGER_PROPERTY = "geopackage.extensions.rtree_index.sql.trigger";
    public static final String TABLE_SUBSTITUTE = GeoPackageProperties.getProperty("geopackage.extensions.rtree_index.sql.substitute", "table");
    public static final String GEOMETRY_COLUMN_SUBSTITUTE = GeoPackageProperties.getProperty("geopackage.extensions.rtree_index.sql.substitute", "geometry_column");
    public static final String PK_COLUMN_SUBSTITUTE = GeoPackageProperties.getProperty("geopackage.extensions.rtree_index.sql.substitute", "pk_column");
    public static final String TRIGGER_SUBSTITUTE = GeoPackageProperties.getProperty("geopackage.extensions.rtree_index.sql.substitute", "trigger");
    public static final String SQL_DIRECTORY = GeoPackageProperties.getProperty("geopackage.extensions.rtree_index.sql", "directory");
    private GeoPackageCoreConnection connection = null;

    protected RTreeIndexCoreExtension(GeoPackageCore geoPackage) {
        super(geoPackage);
        this.connection = geoPackage.getDatabase();
    }

    public Extensions getOrCreate(FeatureTable featureTable) {
        return this.getOrCreate(featureTable.getTableName(), featureTable.getGeometryColumn().getName());
    }

    public Extensions getOrCreate(String tableName, String columnName) {
        return this.getOrCreate(EXTENSION_NAME, tableName, columnName, DEFINITION, ExtensionScopeType.WRITE_ONLY);
    }

    public boolean has(FeatureTable featureTable) {
        return this.has(featureTable.getTableName(), featureTable.getGeometryColumn().getName());
    }

    public boolean has(String tableName, String columnName) {
        return this.has(EXTENSION_NAME, tableName, columnName);
    }

    public boolean has() {
        return this.has(EXTENSION_NAME, null, null);
    }

    public boolean createFunctions(FeatureTable featureTable) {
        return this.createFunctions(featureTable.getTableName(), featureTable.getGeometryColumn().getName());
    }

    public boolean createFunctions(String tableName, String columnName) {
        boolean created = this.has(tableName, columnName);
        if (created) {
            this.createAllFunctions();
        }
        return created;
    }

    public boolean createFunctions() {
        boolean created = this.has();
        if (created) {
            this.createAllFunctions();
        }
        return created;
    }

    public Extensions create(FeatureTable featureTable) {
        return this.create(featureTable.getTableName(), featureTable.getGeometryColumn().getName(), ((FeatureColumn)featureTable.getPkColumn()).getName());
    }

    public Extensions create(String tableName, String geometryColumnName, String idColumnName) {
        Extensions extension = this.getOrCreate(tableName, geometryColumnName);
        this.createAllFunctions();
        this.createRTreeIndex(tableName, geometryColumnName);
        this.loadRTreeIndex(tableName, geometryColumnName, idColumnName);
        this.createAllTriggers(tableName, geometryColumnName, idColumnName);
        return extension;
    }

    public void createRTreeIndex(FeatureTable featureTable) {
        this.createRTreeIndex(featureTable.getTableName(), featureTable.getGeometryColumn().getName());
    }

    public void createRTreeIndex(String tableName, String geometryColumnName) {
        String sqlName = GeoPackageProperties.getProperty(SQL_PROPERTY, CREATE_PROPERTY);
        this.executeSQL(sqlName, tableName, geometryColumnName);
    }

    public void createAllFunctions() {
        this.createMinXFunction();
        this.createMaxXFunction();
        this.createMinYFunction();
        this.createMaxYFunction();
        this.createIsEmptyFunction();
    }

    public abstract void createMinXFunction();

    public abstract void createMaxXFunction();

    public abstract void createMinYFunction();

    public abstract void createMaxYFunction();

    public abstract void createIsEmptyFunction();

    public void loadRTreeIndex(FeatureTable featureTable) {
        this.loadRTreeIndex(featureTable.getTableName(), featureTable.getGeometryColumn().getName(), ((FeatureColumn)featureTable.getPkColumn()).getName());
    }

    public void loadRTreeIndex(String tableName, String geometryColumnName, String idColumnName) {
        String sqlName = GeoPackageProperties.getProperty(SQL_PROPERTY, LOAD_PROPERTY);
        this.executeSQL(sqlName, tableName, geometryColumnName, idColumnName);
    }

    public void createAllTriggers(FeatureTable featureTable) {
        this.createAllTriggers(featureTable.getTableName(), featureTable.getGeometryColumn().getName(), ((FeatureColumn)featureTable.getPkColumn()).getName());
    }

    public void createAllTriggers(String tableName, String geometryColumnName, String idColumnName) {
        this.createInsertTrigger(tableName, geometryColumnName, idColumnName);
        this.createUpdate1Trigger(tableName, geometryColumnName, idColumnName);
        this.createUpdate2Trigger(tableName, geometryColumnName, idColumnName);
        this.createUpdate3Trigger(tableName, geometryColumnName, idColumnName);
        this.createUpdate4Trigger(tableName, geometryColumnName, idColumnName);
        this.createDeleteTrigger(tableName, geometryColumnName, idColumnName);
    }

    public void createInsertTrigger(String tableName, String geometryColumnName, String idColumnName) {
        String sqlName = GeoPackageProperties.getProperty(TRIGGER_PROPERTY, TRIGGER_INSERT_NAME);
        this.executeSQL(sqlName, tableName, geometryColumnName, idColumnName);
    }

    public void createUpdate1Trigger(String tableName, String geometryColumnName, String idColumnName) {
        String sqlName = GeoPackageProperties.getProperty(TRIGGER_PROPERTY, TRIGGER_UPDATE1_NAME);
        this.executeSQL(sqlName, tableName, geometryColumnName, idColumnName);
    }

    public void createUpdate2Trigger(String tableName, String geometryColumnName, String idColumnName) {
        String sqlName = GeoPackageProperties.getProperty(TRIGGER_PROPERTY, TRIGGER_UPDATE2_NAME);
        this.executeSQL(sqlName, tableName, geometryColumnName, idColumnName);
    }

    public void createUpdate3Trigger(String tableName, String geometryColumnName, String idColumnName) {
        String sqlName = GeoPackageProperties.getProperty(TRIGGER_PROPERTY, TRIGGER_UPDATE3_NAME);
        this.executeSQL(sqlName, tableName, geometryColumnName, idColumnName);
    }

    public void createUpdate4Trigger(String tableName, String geometryColumnName, String idColumnName) {
        String sqlName = GeoPackageProperties.getProperty(TRIGGER_PROPERTY, TRIGGER_UPDATE4_NAME);
        this.executeSQL(sqlName, tableName, geometryColumnName, idColumnName);
    }

    public void createDeleteTrigger(String tableName, String geometryColumnName, String idColumnName) {
        String sqlName = GeoPackageProperties.getProperty(TRIGGER_PROPERTY, TRIGGER_DELETE_NAME);
        this.executeSQL(sqlName, tableName, geometryColumnName, idColumnName);
    }

    public void delete(FeatureTable featureTable) {
        this.delete(featureTable.getTableName(), featureTable.getGeometryColumn().getName());
    }

    public void delete(String tableName, String geometryColumnName) {
        this.drop(tableName, geometryColumnName);
        try {
            this.extensionsDao.deleteByExtension(EXTENSION_NAME, tableName, geometryColumnName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete RTree Index extension. GeoPackage: " + this.geoPackage.getName() + ", Table: " + tableName + ", Geometry Column: " + geometryColumnName, e);
        }
    }

    public void drop(FeatureTable featureTable) {
        this.drop(featureTable.getTableName(), featureTable.getGeometryColumn().getName());
    }

    public void drop(String tableName, String geometryColumnName) {
        this.dropAllTriggers(tableName, geometryColumnName);
        this.dropRTreeIndex(tableName, geometryColumnName);
    }

    public void dropRTreeIndex(FeatureTable featureTable) {
        this.dropRTreeIndex(featureTable.getTableName(), featureTable.getGeometryColumn().getName());
    }

    public void dropRTreeIndex(String tableName, String geometryColumnName) {
        String sqlName = GeoPackageProperties.getProperty(SQL_PROPERTY, "drop");
        this.executeSQL(sqlName, tableName, geometryColumnName);
    }

    public void dropTriggers(FeatureTable featureTable) {
        this.dropTriggers(featureTable.getTableName(), featureTable.getGeometryColumn().getName());
    }

    public boolean dropTriggers(String tableName, String columnName) {
        boolean dropped = this.has(tableName, columnName);
        if (dropped) {
            this.dropAllTriggers(tableName, columnName);
        }
        return dropped;
    }

    public void dropAllTriggers(FeatureTable featureTable) {
        this.dropAllTriggers(featureTable.getTableName(), featureTable.getGeometryColumn().getName());
    }

    public void dropAllTriggers(String tableName, String geometryColumnName) {
        this.dropInsertTrigger(tableName, geometryColumnName);
        this.dropUpdate1Trigger(tableName, geometryColumnName);
        this.dropUpdate2Trigger(tableName, geometryColumnName);
        this.dropUpdate3Trigger(tableName, geometryColumnName);
        this.dropUpdate4Trigger(tableName, geometryColumnName);
        this.dropDeleteTrigger(tableName, geometryColumnName);
    }

    public void dropInsertTrigger(String tableName, String geometryColumnName) {
        this.dropTrigger(tableName, geometryColumnName, TRIGGER_INSERT_NAME);
    }

    public void dropUpdate1Trigger(String tableName, String geometryColumnName) {
        this.dropTrigger(tableName, geometryColumnName, TRIGGER_UPDATE1_NAME);
    }

    public void dropUpdate2Trigger(String tableName, String geometryColumnName) {
        this.dropTrigger(tableName, geometryColumnName, TRIGGER_UPDATE2_NAME);
    }

    public void dropUpdate3Trigger(String tableName, String geometryColumnName) {
        this.dropTrigger(tableName, geometryColumnName, TRIGGER_UPDATE3_NAME);
    }

    public void dropUpdate4Trigger(String tableName, String geometryColumnName) {
        this.dropTrigger(tableName, geometryColumnName, TRIGGER_UPDATE4_NAME);
    }

    public void dropDeleteTrigger(String tableName, String geometryColumnName) {
        this.dropTrigger(tableName, geometryColumnName, TRIGGER_DELETE_NAME);
    }

    public void dropTrigger(String tableName, String geometryColumnName, String triggerName) {
        String sqlName = GeoPackageProperties.getProperty(TRIGGER_PROPERTY, "drop");
        this.executeSQL(sqlName, tableName, geometryColumnName, null, triggerName);
    }

    private void executeSQL(String sqlName, String tableName, String geometryColumnName) {
        this.executeSQL(sqlName, tableName, geometryColumnName, null);
    }

    private void executeSQL(String sqlName, String tableName, String geometryColumnName, String idColumnName) {
        this.executeSQL(sqlName, tableName, geometryColumnName, idColumnName, null);
    }

    private void executeSQL(String sqlName, String tableName, String geometryColumnName, String idColumnName, String triggerName) {
        List<String> statements = ResourceIOUtils.parseSQLStatements(SQL_DIRECTORY, sqlName);
        for (String statement : statements) {
            String sql = this.substituteSqlArguments(statement, tableName, geometryColumnName, idColumnName, triggerName);
            this.connection.execSQL(sql);
        }
    }

    private String substituteSqlArguments(String sql, String tableName, String geometryColumnName, String idColumnName, String triggerName) {
        String substituted = sql;
        substituted = substituted.replaceAll(TABLE_SUBSTITUTE, tableName);
        substituted = substituted.replaceAll(GEOMETRY_COLUMN_SUBSTITUTE, geometryColumnName);
        if (idColumnName != null) {
            substituted = substituted.replaceAll(PK_COLUMN_SUBSTITUTE, idColumnName);
        }
        if (triggerName != null) {
            substituted = substituted.replaceAll(TRIGGER_SUBSTITUTE, triggerName);
        }
        return substituted;
    }
}

