/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserUniqueConstraint;

public abstract class UserTable<TColumn extends UserColumn> {
    private final String tableName;
    private final String[] columnNames;
    private final List<TColumn> columns;
    private final Map<String, Integer> nameToIndex;
    private final int pkIndex;
    private final List<UserUniqueConstraint<TColumn>> uniqueConstraints;

    protected UserTable(String tableName, List<TColumn> columns) {
        this.nameToIndex = new HashMap<String, Integer>();
        this.uniqueConstraints = new ArrayList<UserUniqueConstraint<TColumn>>();
        this.tableName = tableName;
        this.columns = columns;
        Integer pk = null;
        HashSet<Integer> indices = new HashSet<Integer>();
        this.columnNames = new String[columns.size()];
        for (UserColumn column : columns) {
            int index = column.getIndex();
            if (column.isPrimaryKey()) {
                if (pk != null) {
                    throw new GeoPackageException("More than one primary key column was found for table '" + tableName + "'. Index " + pk + " and " + index);
                }
                pk = index;
            }
            if (indices.contains(index)) {
                throw new GeoPackageException("Duplicate index: " + index + ", Table Name: " + tableName);
            }
            indices.add(index);
            this.columnNames[index] = column.getName();
            this.nameToIndex.put(column.getName(), index);
        }
        this.pkIndex = pk != null ? pk : -1;
        for (int i = 0; i < columns.size(); ++i) {
            if (indices.contains(i)) continue;
            throw new GeoPackageException("No column found at index: " + i + ", Table Name: " + tableName);
        }
        Collections.sort(columns);
    }

    protected UserTable(UserTable<TColumn> userTable) {
        this.tableName = userTable.tableName;
        this.columnNames = userTable.columnNames;
        this.columns = userTable.columns;
        this.nameToIndex = userTable.nameToIndex;
        this.pkIndex = userTable.pkIndex;
        this.uniqueConstraints = userTable.uniqueConstraints;
    }

    protected void duplicateCheck(int index, Integer previousIndex, String column) {
        if (previousIndex != null) {
            throw new GeoPackageException("More than one " + column + " column was found for table '" + this.tableName + "'. Index " + previousIndex + " and " + index);
        }
    }

    protected void typeCheck(GeoPackageDataType expected, TColumn column) {
        GeoPackageDataType actual = ((UserColumn)column).getDataType();
        if (actual == null || !actual.equals((Object)expected)) {
            throw new GeoPackageException("Unexpected " + ((UserColumn)column).getName() + " column data type was found for table '" + this.tableName + "', expected: " + expected.name() + ", actual: " + (actual != null ? actual.name() : "null"));
        }
    }

    protected void missingCheck(Integer index, String column) {
        if (index == null) {
            throw new GeoPackageException("No " + column + " column was found for table '" + this.tableName + "'");
        }
    }

    public int getColumnIndex(String columnName) {
        Integer index = this.nameToIndex.get(columnName);
        if (index == null) {
            throw new GeoPackageException("Column does not exist in table '" + this.tableName + "', column: " + columnName);
        }
        return index;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getColumnName(int index) {
        return this.columnNames[index];
    }

    public List<TColumn> getColumns() {
        return this.columns;
    }

    public TColumn getColumn(int index) {
        return (TColumn)((UserColumn)this.columns.get(index));
    }

    public TColumn getColumn(String columnName) {
        return this.getColumn(this.getColumnIndex(columnName));
    }

    public boolean hasColumn(String columnName) {
        return this.nameToIndex.containsKey(columnName);
    }

    public int columnCount() {
        return this.columns.size();
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean hasPkColumn() {
        return this.pkIndex >= 0;
    }

    public int getPkColumnIndex() {
        return this.pkIndex;
    }

    public TColumn getPkColumn() {
        UserColumn column = null;
        if (this.hasPkColumn()) {
            column = (UserColumn)this.columns.get(this.pkIndex);
        }
        return (TColumn)column;
    }

    public void addUniqueConstraint(UserUniqueConstraint<TColumn> uniqueConstraint) {
        this.uniqueConstraints.add(uniqueConstraint);
    }

    public List<UserUniqueConstraint<TColumn>> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public List<TColumn> columnsOfType(GeoPackageDataType type) {
        ArrayList<UserColumn> columnsOfType = new ArrayList<UserColumn>();
        for (UserColumn column : this.columns) {
            if (column.getDataType() != type) continue;
            columnsOfType.add(column);
        }
        return columnsOfType;
    }
}

