/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mil.nga.geopackage.GeoPackageCore;

public abstract class GeoPackageCoreCache<T extends GeoPackageCore> {
    private Map<String, T> cache = new HashMap<String, T>();

    public Set<String> getNames() {
        return this.cache.keySet();
    }

    public Collection<T> getGeoPackages() {
        return this.cache.values();
    }

    public T get(String name) {
        return (T)((GeoPackageCore)this.cache.get(name));
    }

    public boolean exists(String name) {
        return this.cache.containsKey(name);
    }

    public void closeAll() {
        for (GeoPackageCore geoPackage : this.cache.values()) {
            geoPackage.close();
        }
        this.cache.clear();
    }

    public void add(T geoPackage) {
        this.cache.put(geoPackage.getName(), geoPackage);
    }

    public void addAll(Collection<T> geoPackages) {
        for (GeoPackageCore geoPackage : geoPackages) {
            this.add(geoPackage);
        }
    }

    public T remove(String name) {
        return (T)((GeoPackageCore)this.cache.remove(name));
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean removeAndClose(String name) {
        return this.close(name);
    }

    public boolean close(String name) {
        T geoPackage = this.remove(name);
        if (geoPackage != null) {
            geoPackage.close();
        }
        return geoPackage != null;
    }

    public void closeRetain(Collection<String> retain) {
        HashSet<String> close = new HashSet<String>(this.cache.keySet());
        close.removeAll(retain);
        for (String name : close) {
            this.close(name);
        }
    }

    public void close(Collection<String> names) {
        for (String name : names) {
            this.close(name);
        }
    }
}

