/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.coverage;

import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;

public class CoverageDataRequest {
    private BoundingBox boundingBox;
    private boolean point;
    private BoundingBox projectedBoundingBox;

    public CoverageDataRequest(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public CoverageDataRequest(double latitude, double longitude) {
        this(new BoundingBox(longitude, latitude, longitude, latitude));
        this.point = true;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public boolean isPoint() {
        return this.point;
    }

    public BoundingBox getProjectedBoundingBox() {
        return this.projectedBoundingBox;
    }

    public void setProjectedBoundingBox(BoundingBox projectedBoundingBox) {
        this.projectedBoundingBox = projectedBoundingBox;
    }

    public BoundingBox overlap(BoundingBox projectedCoverage) {
        BoundingBox overlap = null;
        overlap = this.point ? this.projectedBoundingBox : TileBoundingBoxUtils.overlap(this.projectedBoundingBox, projectedCoverage);
        return overlap;
    }
}

