/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.related.media;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.extension.related.RelationType;
import mil.nga.geopackage.extension.related.UserRelatedTable;
import mil.nga.geopackage.user.custom.UserCustomColumn;
import mil.nga.geopackage.user.custom.UserCustomTable;

public class MediaTable
extends UserRelatedTable {
    public static final RelationType RELATION_TYPE = RelationType.MEDIA;
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_DATA = "data";
    public static final String COLUMN_CONTENT_TYPE = "content_type";

    public static MediaTable create(String tableName) {
        return MediaTable.create(tableName, null, null);
    }

    public static MediaTable create(String tableName, List<UserCustomColumn> additionalColumns) {
        return MediaTable.create(tableName, null, additionalColumns);
    }

    public static MediaTable create(String tableName, String idColumnName) {
        return MediaTable.create(tableName, idColumnName, null);
    }

    public static MediaTable create(String tableName, String idColumnName, List<UserCustomColumn> additionalColumns) {
        ArrayList<UserCustomColumn> columns = new ArrayList<UserCustomColumn>();
        columns.addAll(MediaTable.createRequiredColumns(idColumnName));
        if (additionalColumns != null) {
            columns.addAll(additionalColumns);
        }
        return new MediaTable(tableName, columns, MediaTable.requiredColumns(idColumnName));
    }

    public static List<UserCustomColumn> createRequiredColumns() {
        return MediaTable.createRequiredColumns(0);
    }

    public static List<UserCustomColumn> createRequiredColumns(String idColumnName) {
        return MediaTable.createRequiredColumns(0, idColumnName);
    }

    public static List<UserCustomColumn> createRequiredColumns(int startingIndex) {
        return MediaTable.createRequiredColumns(startingIndex, null);
    }

    public static List<UserCustomColumn> createRequiredColumns(int startingIndex, String idColumnName) {
        if (idColumnName == null) {
            idColumnName = COLUMN_ID;
        }
        ArrayList<UserCustomColumn> columns = new ArrayList<UserCustomColumn>();
        columns.add(MediaTable.createIdColumn(startingIndex++, idColumnName));
        columns.add(MediaTable.createDataColumn(startingIndex++));
        columns.add(MediaTable.createContentTypeColumn(startingIndex++));
        return columns;
    }

    public static UserCustomColumn createIdColumn(int index, String idColumnName) {
        return UserCustomColumn.createPrimaryKeyColumn(index, idColumnName);
    }

    public static UserCustomColumn createDataColumn(int index) {
        return UserCustomColumn.createColumn(index, COLUMN_DATA, GeoPackageDataType.BLOB, true, null);
    }

    public static UserCustomColumn createContentTypeColumn(int index) {
        return UserCustomColumn.createColumn(index, COLUMN_CONTENT_TYPE, GeoPackageDataType.TEXT, true, null);
    }

    public static int numRequiredColumns() {
        return MediaTable.requiredColumns().size();
    }

    public static List<String> requiredColumns() {
        return MediaTable.requiredColumns(null);
    }

    public static List<String> requiredColumns(String idColumnName) {
        if (idColumnName == null) {
            idColumnName = COLUMN_ID;
        }
        ArrayList<String> requiredColumns = new ArrayList<String>();
        requiredColumns.add(idColumnName);
        requiredColumns.add(COLUMN_DATA);
        requiredColumns.add(COLUMN_CONTENT_TYPE);
        return requiredColumns;
    }

    private MediaTable(String tableName, List<UserCustomColumn> columns, Collection<String> requiredColumns) {
        super(tableName, RELATION_TYPE.getName(), columns, requiredColumns);
    }

    MediaTable(UserCustomTable table) {
        super(RELATION_TYPE.getName(), table);
    }

    public int getIdColumnIndex() {
        return this.getPkColumnIndex();
    }

    public UserCustomColumn getIdColumn() {
        return (UserCustomColumn)this.getPkColumn();
    }

    public int getDataColumnIndex() {
        return this.getColumnIndex(COLUMN_DATA);
    }

    public UserCustomColumn getDataColumn() {
        return (UserCustomColumn)this.getColumn(COLUMN_DATA);
    }

    public int getContentTypeColumnIndex() {
        return this.getColumnIndex(COLUMN_CONTENT_TYPE);
    }

    public UserCustomColumn getContentTypeColumn() {
        return (UserCustomColumn)this.getColumn(COLUMN_CONTENT_TYPE);
    }
}

