/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.user.ColumnValue;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserCoreConnection;
import mil.nga.geopackage.user.UserCoreResult;
import mil.nga.geopackage.user.UserCoreRow;
import mil.nga.geopackage.user.UserTable;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionTransform;
import org.osgeo.proj4j.units.DegreeUnit;

public abstract class UserCoreDao<TColumn extends UserColumn, TTable extends UserTable<TColumn>, TRow extends UserCoreRow<TColumn, TTable>, TResult extends UserCoreResult<TColumn, TTable, TRow>> {
    private final String database;
    private final GeoPackageCoreConnection db;
    private final UserCoreConnection<TColumn, TTable, TRow, TResult> userDb;
    private final TTable table;
    protected Projection projection;

    protected UserCoreDao(String database, GeoPackageCoreConnection db, UserCoreConnection<TColumn, TTable, TRow, TResult> userDb, TTable table) {
        this.database = database;
        this.db = db;
        this.userDb = userDb;
        this.table = table;
    }

    public abstract TRow newRow();

    public abstract BoundingBox getBoundingBox();

    protected abstract TResult prepareResult(TResult var1);

    public String getDatabase() {
        return this.database;
    }

    public GeoPackageCoreConnection getDb() {
        return this.db;
    }

    public UserCoreConnection<TColumn, TTable, TRow, TResult> getUserDb() {
        return this.userDb;
    }

    public String getTableName() {
        return ((UserTable)this.table).getTableName();
    }

    public TTable getTable() {
        return this.table;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void dropTable() {
        this.db.execSQL("DROP TABLE IF EXISTS " + CoreSQLUtils.quoteWrap(this.getTableName()));
    }

    public TResult queryForAll() {
        TResult result = this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), null, null, null, null, null);
        this.prepareResult(result);
        return result;
    }

    public TResult queryForAll(String[] columnsAs) {
        TResult result = this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), columnsAs, null, null, null, null, null);
        this.prepareResult(result);
        return result;
    }

    public TResult queryForEq(String fieldName, Object value) {
        return this.queryForEq(fieldName, value, null, null, null);
    }

    public TResult queryForEq(String fieldName, Object value, String groupBy, String having, String orderBy) {
        String where = this.buildWhere(fieldName, value);
        String[] whereArgs = this.buildWhereArgs(value);
        TResult result = this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, groupBy, having, orderBy);
        this.prepareResult(result);
        return result;
    }

    public TResult queryForEq(String fieldName, ColumnValue value) {
        String where = this.buildWhere(fieldName, value);
        String[] whereArgs = this.buildWhereArgs(value);
        TResult result = this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, null, null, null);
        this.prepareResult(result);
        return result;
    }

    public TResult queryForLike(String fieldName, Object value) {
        return this.queryForLike(fieldName, value, null, null, null);
    }

    public TResult queryForLike(String fieldName, Object value, String groupBy, String having, String orderBy) {
        String where = this.buildWhereLike(fieldName, value);
        String[] whereArgs = this.buildWhereArgs(value);
        TResult result = this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, groupBy, having, orderBy);
        this.prepareResult(result);
        return result;
    }

    public TResult queryForLike(String fieldName, ColumnValue value) {
        String where = this.buildWhereLike(fieldName, value);
        String[] whereArgs = this.buildWhereArgs(value);
        TResult result = this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, null, null, null);
        this.prepareResult(result);
        return result;
    }

    public TResult queryForFieldValues(Map<String, Object> fieldValues) {
        String where = this.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.buildWhereArgs(fieldValues.values());
        TResult result = this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, null, null, null);
        this.prepareResult(result);
        return result;
    }

    public TResult queryForValueFieldValues(Map<String, ColumnValue> fieldValues) {
        String where = this.buildValueWhere(fieldValues.entrySet());
        String[] whereArgs = this.buildValueWhereArgs(fieldValues.values());
        TResult result = this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, null, null, null);
        this.prepareResult(result);
        return result;
    }

    public TResult queryForId(long id) {
        String where = this.getPkWhere(id);
        String[] whereArgs = this.getPkWhereArgs(id);
        TResult result = this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, null, null, null);
        this.prepareResult(result);
        return result;
    }

    public TRow queryForIdRow(long id) {
        TRow row = null;
        TResult readCursor = this.queryForId(id);
        if (readCursor.moveToNext()) {
            row = readCursor.getRow();
        }
        readCursor.close();
        return row;
    }

    public TResult query(String where, String[] whereArgs) {
        TResult result = this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, null, null, null);
        this.prepareResult(result);
        return result;
    }

    public TResult query(String where, String[] whereArgs, String groupBy, String having, String orderBy) {
        TResult result = this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, groupBy, having, orderBy);
        this.prepareResult(result);
        return result;
    }

    public TResult query(String where, String[] whereArgs, String groupBy, String having, String orderBy, String limit) {
        TResult result = this.userDb.query(this.getTableName(), ((UserTable)this.table).getColumnNames(), where, whereArgs, groupBy, having, orderBy, limit);
        this.prepareResult(result);
        return result;
    }

    public abstract int update(TRow var1);

    public int delete(TRow row) {
        int numDeleted = ((UserCoreRow)row).hasId() ? this.deleteById(((UserCoreRow)row).getId()) : this.delete(this.buildValueWhere(((UserCoreRow)row).getAsMap()), this.buildWhereArgs(((UserCoreRow)row).getValues()));
        return numDeleted;
    }

    public int deleteById(long id) {
        return this.db.delete(this.getTableName(), this.getPkWhere(id), this.getPkWhereArgs(id));
    }

    public int delete(String whereClause, String[] whereArgs) {
        return this.db.delete(this.getTableName(), whereClause, whereArgs);
    }

    public int delete(Map<String, Object> fieldValues) {
        String whereClause = this.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.buildWhereArgs(fieldValues.values());
        return this.delete(whereClause, whereArgs);
    }

    public int deleteAll() {
        return this.delete(null, null);
    }

    public long create(TRow row) {
        return this.insert(row);
    }

    public abstract long insert(TRow var1);

    protected String getPkWhere(long id) {
        return this.buildWhere(((UserColumn)((UserTable)this.table).getPkColumn()).getName(), id);
    }

    protected String[] getPkWhereArgs(long id) {
        return this.buildWhereArgs(id);
    }

    public String buildWhere(Set<Map.Entry<String, Object>> fields) {
        StringBuilder selection = new StringBuilder();
        for (Map.Entry<String, Object> field : fields) {
            if (selection.length() > 0) {
                selection.append(" AND ");
            }
            selection.append(this.buildWhere(field.getKey(), field.getValue()));
        }
        return selection.toString();
    }

    public String buildValueWhere(Set<Map.Entry<String, ColumnValue>> fields) {
        StringBuilder selection = new StringBuilder();
        for (Map.Entry<String, ColumnValue> field : fields) {
            if (selection.length() > 0) {
                selection.append(" AND ");
            }
            selection.append(this.buildWhere(field.getKey(), field.getValue()));
        }
        return selection.toString();
    }

    public String buildWhere(String field, Object value) {
        return this.buildWhere(field, value, "=");
    }

    public String buildWhereLike(String field, Object value) {
        return this.buildWhere(field, value, "LIKE");
    }

    public String buildWhere(String field, Object value, String operation) {
        return CoreSQLUtils.quoteWrap(field) + " " + (value != null ? operation + " ?" : "IS NULL");
    }

    public String buildWhere(String field, ColumnValue value) {
        String where;
        if (value != null) {
            if (value.getValue() != null && value.getTolerance() != null) {
                if (!(value.getValue() instanceof Number)) {
                    throw new GeoPackageException("Field value is not a number and can not use a tolerance, Field: " + field + ", Value: " + value);
                }
                String quotedField = CoreSQLUtils.quoteWrap(field);
                where = quotedField + " >= ? AND " + quotedField + " <= ?";
            } else {
                where = this.buildWhere(field, value.getValue());
            }
        } else {
            where = this.buildWhere(field, null, null);
        }
        return where;
    }

    public String buildWhereLike(String field, ColumnValue value) {
        String where;
        if (value != null) {
            if (value.getTolerance() != null) {
                throw new GeoPackageException("Field value tolerance not supported for LIKE query, Field: " + field + ", Value: " + ", Tolerance: " + value.getTolerance());
            }
            where = this.buildWhereLike(field, value.getValue());
        } else {
            where = this.buildWhere(field, null, null);
        }
        return where;
    }

    public String[] buildWhereArgs(Collection<Object> values) {
        ArrayList<String> selectionArgs = new ArrayList<String>();
        for (Object value : values) {
            if (value == null) continue;
            selectionArgs.add(value.toString());
        }
        return selectionArgs.isEmpty() ? null : selectionArgs.toArray(new String[0]);
    }

    public String[] buildWhereArgs(Object[] values) {
        ArrayList<String> selectionArgs = new ArrayList<String>();
        for (Object value : values) {
            if (value == null) continue;
            selectionArgs.add(value.toString());
        }
        return selectionArgs.isEmpty() ? null : selectionArgs.toArray(new String[0]);
    }

    public String[] buildValueWhereArgs(Collection<ColumnValue> values) {
        ArrayList<String> selectionArgs = new ArrayList<String>();
        for (ColumnValue value : values) {
            if (value == null || value.getValue() == null) continue;
            if (value.getTolerance() != null) {
                String[] toleranceArgs = this.getValueToleranceRange(value);
                selectionArgs.add(toleranceArgs[0]);
                selectionArgs.add(toleranceArgs[1]);
                continue;
            }
            selectionArgs.add(value.getValue().toString());
        }
        return selectionArgs.isEmpty() ? null : selectionArgs.toArray(new String[0]);
    }

    public String[] buildWhereArgs(Object value) {
        String[] args = null;
        if (value != null) {
            args = new String[]{value.toString()};
        }
        return args;
    }

    public String[] buildWhereArgs(ColumnValue value) {
        String[] args = null;
        if (value != null) {
            args = value.getValue() != null && value.getTolerance() != null ? this.getValueToleranceRange(value) : this.buildWhereArgs(value.getValue());
        }
        return args;
    }

    public int count() {
        return this.count(null, null);
    }

    public int count(String where, String[] args) {
        return this.db.count(this.getTableName(), where, args);
    }

    public Integer min(String column, String where, String[] args) {
        return this.db.min(this.getTableName(), column, where, args);
    }

    public Integer max(String column, String where, String[] args) {
        return this.db.max(this.getTableName(), column, where, args);
    }

    public String querySingleStringResult(String sql, String[] args) {
        return this.db.querySingleStringResult(sql, args);
    }

    public Integer querySingleIntResult(String sql, String[] args) {
        return this.db.querySingleIntResult(sql, args);
    }

    public List<String> querySingleColumnStringResults(String sql, String[] args) {
        return this.db.querySingleColumnStringResults(sql, args);
    }

    public int getZoomLevel() {
        Projection projection = this.getProjection();
        if (projection == null) {
            throw new GeoPackageException("No projection was set which is required to determine the zoom level");
        }
        int zoomLevel = 0;
        BoundingBox boundingBox = this.getBoundingBox();
        if (boundingBox != null) {
            if (projection.getUnit() instanceof DegreeUnit) {
                boundingBox = TileBoundingBoxUtils.boundDegreesBoundingBoxWithWebMercatorLimits(boundingBox);
            }
            ProjectionTransform webMercatorTransform = projection.getTransformation(3857L);
            BoundingBox webMercatorBoundingBox = boundingBox.transform(webMercatorTransform);
            zoomLevel = TileBoundingBoxUtils.getZoomLevel(webMercatorBoundingBox);
        }
        return zoomLevel;
    }

    public String[] buildColumnsAsNull(List<TColumn> columns) {
        return this.buildColumnsAs(columns, "null");
    }

    public String[] buildColumnsAs(List<TColumn> columns, String value) {
        String[] columnsArray = this.buildColumnsArray(columns);
        return this.buildColumnsAs(columnsArray, value);
    }

    public String[] buildColumnsAsNull(String[] columns) {
        return this.buildColumnsAs(columns, "null");
    }

    public String[] buildColumnsAs(String[] columns, String value) {
        String[] values = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            values[i] = value;
        }
        return this.buildColumnsAs(columns, values);
    }

    public String[] buildColumnsAs(List<TColumn> columns, String[] values) {
        String[] columnsArray = this.buildColumnsArray(columns);
        return this.buildColumnsAs(columnsArray, values);
    }

    public String[] buildColumnsAs(String[] columns, String[] values) {
        HashMap<String, String> columnsMap = new HashMap<String, String>();
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            String value = values[i];
            columnsMap.put(column, value);
        }
        return this.buildColumnsAs(columnsMap);
    }

    public String[] buildColumnsAs(Map<String, String> columns) {
        String[] columnNames = ((UserTable)this.table).getColumnNames();
        String[] columnsAs = new String[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            String column = columnNames[i];
            columnsAs[i] = columns.get(column);
        }
        return columnsAs;
    }

    private String[] buildColumnsArray(List<TColumn> columns) {
        String[] columnsArray = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            UserColumn column = (UserColumn)columns.get(i);
            columnsArray[i] = column.getName();
        }
        return columnsArray;
    }

    private String[] getValueToleranceRange(ColumnValue value) {
        double doubleValue = ((Number)value.getValue()).doubleValue();
        double tolerance = value.getTolerance();
        return new String[]{Double.toString(doubleValue - tolerance), Double.toString(doubleValue + tolerance)};
    }
}

