/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage;

import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.proj.ProjectionConstants;
import mil.nga.sf.proj.ProjectionTransform;

public class BoundingBox {
    private double minLongitude;
    private double maxLongitude;
    private double minLatitude;
    private double maxLatitude;

    public BoundingBox() {
        this(-ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH, -ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT, ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH, ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT);
    }

    public BoundingBox(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude) {
        this.minLongitude = minLongitude;
        this.minLatitude = minLatitude;
        this.maxLongitude = maxLongitude;
        this.maxLatitude = maxLatitude;
    }

    public BoundingBox(BoundingBox boundingBox) {
        this(boundingBox.getMinLongitude(), boundingBox.getMinLatitude(), boundingBox.getMaxLongitude(), boundingBox.getMaxLatitude());
    }

    public BoundingBox(GeometryEnvelope envelope) {
        this(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public double getMinLongitude() {
        return this.minLongitude;
    }

    public void setMinLongitude(double minLongitude) {
        this.minLongitude = minLongitude;
    }

    public double getMaxLongitude() {
        return this.maxLongitude;
    }

    public void setMaxLongitude(double maxLongitude) {
        this.maxLongitude = maxLongitude;
    }

    public double getMinLatitude() {
        return this.minLatitude;
    }

    public void setMinLatitude(double minLatitude) {
        this.minLatitude = minLatitude;
    }

    public double getMaxLatitude() {
        return this.maxLatitude;
    }

    public void setMaxLatitude(double maxLatitude) {
        this.maxLatitude = maxLatitude;
    }

    public GeometryEnvelope buildEnvelope() {
        GeometryEnvelope envelope = new GeometryEnvelope();
        envelope.setMinX(this.minLongitude);
        envelope.setMaxX(this.maxLongitude);
        envelope.setMinY(this.minLatitude);
        envelope.setMaxY(this.maxLatitude);
        return envelope;
    }

    public BoundingBox complementary(double maxProjectionLongitude) {
        BoundingBox complementary = null;
        Double adjust = null;
        if (this.maxLongitude > maxProjectionLongitude) {
            if (this.minLongitude >= -maxProjectionLongitude) {
                adjust = -2.0 * maxProjectionLongitude;
            }
        } else if (this.minLongitude < -maxProjectionLongitude && this.maxLongitude <= maxProjectionLongitude) {
            adjust = 2.0 * maxProjectionLongitude;
        }
        if (adjust != null) {
            complementary = new BoundingBox(this);
            complementary.setMinLongitude(complementary.getMinLongitude() + adjust);
            complementary.setMaxLongitude(complementary.getMaxLongitude() + adjust);
        }
        return complementary;
    }

    public BoundingBox complementaryWgs84() {
        return this.complementary(ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH);
    }

    public BoundingBox complementaryWebMercator() {
        return this.complementary(ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH);
    }

    public BoundingBox boundCoordinates(double maxProjectionLongitude) {
        BoundingBox bounded = new BoundingBox(this);
        double minLongitude = (this.getMinLongitude() + maxProjectionLongitude) % (2.0 * maxProjectionLongitude) - maxProjectionLongitude;
        double maxLongitude = (this.getMaxLongitude() + maxProjectionLongitude) % (2.0 * maxProjectionLongitude) - maxProjectionLongitude;
        bounded.setMinLongitude(minLongitude);
        bounded.setMaxLongitude(maxLongitude);
        return bounded;
    }

    public BoundingBox boundWgs84Coordinates() {
        return this.boundCoordinates(ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH);
    }

    public BoundingBox boundWebMercatorCoordinates() {
        return this.boundCoordinates(ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH);
    }

    public BoundingBox expandCoordinates(double maxProjectionLongitude) {
        double maxLongitude;
        BoundingBox expanded = new BoundingBox(this);
        double minLongitude = this.getMinLongitude();
        if (minLongitude > (maxLongitude = this.getMaxLongitude())) {
            int worldWraps = 1 + (int)((minLongitude - maxLongitude) / (2.0 * maxProjectionLongitude));
            expanded.setMaxLongitude(maxLongitude += (double)(worldWraps * 2) * maxProjectionLongitude);
        }
        return expanded;
    }

    public BoundingBox expandWgs84Coordinates() {
        return this.expandCoordinates(ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH);
    }

    public BoundingBox expandWebMercatorCoordinates() {
        return this.expandCoordinates(ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH);
    }

    public BoundingBox transform(ProjectionTransform transform) {
        GeometryEnvelope envelope = this.buildEnvelope();
        GeometryEnvelope transformedEnvelope = transform.transform(envelope);
        BoundingBox transformed = new BoundingBox(transformedEnvelope);
        return transformed;
    }

    public boolean intersects(BoundingBox boundingBox) {
        return this.overlap(boundingBox) != null;
    }

    public boolean intersects(BoundingBox boundingBox, boolean allowEmpty) {
        return this.overlap(boundingBox, allowEmpty) != null;
    }

    public BoundingBox overlap(BoundingBox boundingBox) {
        return this.overlap(boundingBox, false);
    }

    public BoundingBox overlap(BoundingBox boundingBox, boolean allowEmpty) {
        double minLongitude = Math.max(this.getMinLongitude(), boundingBox.getMinLongitude());
        double maxLongitude = Math.min(this.getMaxLongitude(), boundingBox.getMaxLongitude());
        double minLatitude = Math.max(this.getMinLatitude(), boundingBox.getMinLatitude());
        double maxLatitude = Math.min(this.getMaxLatitude(), boundingBox.getMaxLatitude());
        BoundingBox overlap = null;
        if (minLongitude < maxLongitude && minLatitude < maxLatitude || allowEmpty && minLongitude <= maxLongitude && minLatitude <= maxLatitude) {
            overlap = new BoundingBox(minLongitude, minLatitude, maxLongitude, maxLatitude);
        }
        return overlap;
    }

    public BoundingBox union(BoundingBox boundingBox) {
        double minLongitude = Math.min(this.getMinLongitude(), boundingBox.getMinLongitude());
        double maxLongitude = Math.max(this.getMaxLongitude(), boundingBox.getMaxLongitude());
        double minLatitude = Math.min(this.getMinLatitude(), boundingBox.getMinLatitude());
        double maxLatitude = Math.max(this.getMaxLatitude(), boundingBox.getMaxLatitude());
        BoundingBox union = null;
        if (minLongitude < maxLongitude && minLatitude < maxLatitude) {
            union = new BoundingBox(minLongitude, minLatitude, maxLongitude, maxLatitude);
        }
        return union;
    }

    public boolean contains(BoundingBox boundingBox) {
        return this.getMinLongitude() <= boundingBox.getMinLongitude() && this.getMaxLongitude() >= boundingBox.getMaxLongitude() && this.getMinLatitude() <= boundingBox.getMinLatitude() && this.getMaxLatitude() >= boundingBox.getMaxLatitude();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.maxLatitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLongitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLatitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLongitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        if (Double.doubleToLongBits(this.maxLatitude) != Double.doubleToLongBits(other.maxLatitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxLongitude) != Double.doubleToLongBits(other.maxLongitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minLatitude) != Double.doubleToLongBits(other.minLatitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.minLongitude) == Double.doubleToLongBits(other.minLongitude);
    }
}

