/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.NGAExtensions;

public class GeoPackageExtensions {
    public static void deleteTableExtensions(GeoPackageCore geoPackage, String table) {
        NGAExtensions.deleteTableExtensions(geoPackage, table);
        GeoPackageExtensions.delete(geoPackage, table);
    }

    public static void deleteExtensions(GeoPackageCore geoPackage) {
        GeoPackageExtensions.deleteExtensions(geoPackage, false);
    }

    public static void deleteExtensions(GeoPackageCore geoPackage, boolean ignoreErrors) {
        NGAExtensions.deleteExtensions(geoPackage, ignoreErrors);
        GeoPackageExtensions.delete(geoPackage, ignoreErrors);
    }

    private static void delete(GeoPackageCore geoPackage, String table) {
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table extensions. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    private static void delete(GeoPackageCore geoPackage, boolean ignoreErrors) {
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteAll();
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete all extensions. GeoPackage: " + geoPackage.getName(), e);
        }
    }
}

