/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.coverage;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import mil.nga.geopackage.extension.coverage.GriddedCoverageDao;
import mil.nga.geopackage.extension.coverage.GriddedCoverageDataType;
import mil.nga.geopackage.extension.coverage.GriddedCoverageEncodingType;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;

@DatabaseTable(tableName="gpkg_2d_gridded_coverage_ancillary", daoClass=GriddedCoverageDao.class)
public class GriddedCoverage {
    public static final String TABLE_NAME = "gpkg_2d_gridded_coverage_ancillary";
    public static final String COLUMN_ID = "id";
    public static final String COLUMN_TILE_MATRIX_SET_NAME = "tile_matrix_set_name";
    public static final String COLUMN_DATATYPE = "datatype";
    public static final String COLUMN_SCALE = "scale";
    public static final String COLUMN_OFFSET = "offset";
    public static final String COLUMN_PRECISION = "precision";
    public static final String COLUMN_DATA_NULL = "data_null";
    public static final String COLUMN_GRID_CELL_ENCODING = "grid_cell_encoding";
    public static final String COLUMN_UOM = "uom";
    public static final String COLUMN_FIELD_NAME = "field_name";
    public static final String COLUMN_QUANTITY_DEFINITION = "quantity_definition";
    @DatabaseField(columnName="id", generatedId=true, canBeNull=false)
    private long id;
    @DatabaseField(columnName="tile_matrix_set_name", canBeNull=false, foreign=true, foreignAutoRefresh=true)
    private TileMatrixSet tileMatrixSet;
    @DatabaseField(columnName="tile_matrix_set_name", canBeNull=false)
    private String tileMatrixSetName;
    @DatabaseField(columnName="datatype", canBeNull=false, defaultValue="integer")
    private String datatype;
    @DatabaseField(columnName="scale", canBeNull=false, defaultValue="1.0")
    private double scale = 1.0;
    @DatabaseField(columnName="offset", canBeNull=false, defaultValue="0.0")
    private double offset = 0.0;
    @DatabaseField(columnName="precision", defaultValue="1.0")
    private Double precision = 1.0;
    @DatabaseField(columnName="data_null")
    private Double dataNull;
    @DatabaseField(columnName="grid_cell_encoding", defaultValue="grid-value-is-center")
    private String gridCellEncoding;
    @DatabaseField(columnName="uom")
    private String uom;
    @DatabaseField(columnName="field_name", defaultValue="Height")
    private String fieldName;
    @DatabaseField(columnName="quantity_definition", defaultValue="Height")
    private String quantityDefinition;

    public GriddedCoverage() {
    }

    public GriddedCoverage(GriddedCoverage griddedCoverage) {
        this.id = griddedCoverage.id;
        this.tileMatrixSet = griddedCoverage.tileMatrixSet;
        this.tileMatrixSetName = griddedCoverage.tileMatrixSetName;
        this.datatype = griddedCoverage.datatype;
        this.scale = griddedCoverage.scale;
        this.offset = griddedCoverage.offset;
        this.precision = griddedCoverage.precision;
        this.dataNull = griddedCoverage.dataNull;
        this.gridCellEncoding = griddedCoverage.gridCellEncoding;
        this.uom = griddedCoverage.uom;
        this.fieldName = griddedCoverage.fieldName;
        this.quantityDefinition = griddedCoverage.quantityDefinition;
    }

    public long getId() {
        return this.id;
    }

    public TileMatrixSet getTileMatrixSet() {
        return this.tileMatrixSet;
    }

    public void setTileMatrixSet(TileMatrixSet tileMatrixSet) {
        this.tileMatrixSet = tileMatrixSet;
        this.tileMatrixSetName = tileMatrixSet != null ? tileMatrixSet.getTableName() : null;
    }

    public String getTileMatrixSetName() {
        return this.tileMatrixSetName;
    }

    public GriddedCoverageDataType getDataType() {
        return GriddedCoverageDataType.fromName(this.datatype);
    }

    public void setDataType(GriddedCoverageDataType datatype) {
        this.datatype = datatype.getName();
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public double getPrecision() {
        return this.precision != null ? this.precision : 1.0;
    }

    public void setPrecision(Double precision) {
        this.precision = precision;
    }

    public Double getDataNull() {
        return this.dataNull;
    }

    public void setDataNull(Double dataNull) {
        this.dataNull = dataNull;
    }

    public GriddedCoverageEncodingType getGridCellEncodingType() {
        return GriddedCoverageEncodingType.fromName(this.gridCellEncoding);
    }

    public void setGridCellEncodingType(GriddedCoverageEncodingType encodingtype) {
        this.setGridCellEncoding(encodingtype.getName());
    }

    public String getGridCellEncoding() {
        return this.gridCellEncoding;
    }

    public void setGridCellEncoding(String gridCellEncoding) {
        this.gridCellEncoding = gridCellEncoding;
    }

    public String getUom() {
        return this.uom;
    }

    public void setUom(String uom) {
        this.uom = uom;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getQuantityDefinition() {
        return this.quantityDefinition;
    }

    public void setQuantityDefinition(String quantityDefinition) {
        this.quantityDefinition = quantityDefinition;
    }
}

