/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.related;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.extension.related.ExtendedRelation;
import mil.nga.geopackage.schema.TableColumnKey;

public class ExtendedRelationsDao
extends BaseDaoImpl<ExtendedRelation, TableColumnKey> {
    public ExtendedRelationsDao(ConnectionSource connectionSource, Class<ExtendedRelation> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public List<String> getBaseTables() throws SQLException {
        ArrayList<String> baseTables = new ArrayList<String>();
        List extendedRelations = this.queryForAll();
        for (ExtendedRelation extendedRelation : extendedRelations) {
            baseTables.add(extendedRelation.getBaseTableName());
        }
        return baseTables;
    }

    public List<String> getRelatedTables() throws SQLException {
        ArrayList<String> relatedTables = new ArrayList<String>();
        List extendedRelations = this.queryForAll();
        for (ExtendedRelation extendedRelation : extendedRelations) {
            relatedTables.add(extendedRelation.getRelatedTableName());
        }
        return relatedTables;
    }

    public List<ExtendedRelation> getBaseTableRelations(String baseTable) throws SQLException {
        return this.queryForEq("base_table_name", baseTable);
    }

    public List<ExtendedRelation> getRelatedTableRelations(String relatedTable) throws SQLException {
        return this.queryForEq("related_table_name", relatedTable);
    }

    public List<ExtendedRelation> getTableRelations(String table) throws SQLException {
        QueryBuilder qb = this.queryBuilder();
        qb.where().like("base_table_name", (Object)table).or().like("related_table_name", (Object)table);
        PreparedQuery preparedQuery = qb.prepare();
        return this.query(preparedQuery);
    }
}

