/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.related;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.related.ExtendedRelation;
import mil.nga.geopackage.extension.related.ExtendedRelationsDao;
import mil.nga.geopackage.extension.related.RelationType;
import mil.nga.geopackage.extension.related.UserMappingTable;
import mil.nga.geopackage.extension.related.UserRelatedTable;
import mil.nga.geopackage.extension.related.media.MediaTable;
import mil.nga.geopackage.extension.related.simple.SimpleAttributesTable;
import mil.nga.geopackage.property.GeoPackageProperties;

public abstract class RelatedTablesCoreExtension
extends BaseExtension {
    public static final String EXTENSION_AUTHOR = "gpkg";
    public static final String EXTENSION_NAME_NO_AUTHOR = "related_tables";
    public static final String EXTENSION_NAME = "related_tables";
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty("geopackage.extensions", "related_tables");
    private final ExtendedRelationsDao extendedRelationsDao;

    protected RelatedTablesCoreExtension(GeoPackageCore geoPackage) {
        super(geoPackage);
        this.extendedRelationsDao = geoPackage.getExtendedRelationsDao();
    }

    public ExtendedRelationsDao getExtendedRelationsDao() {
        return this.extendedRelationsDao;
    }

    private Extensions getOrCreate() {
        this.geoPackage.createExtendedRelationsTable();
        Extensions extension = this.getOrCreate("related_tables", "gpkgext_relations", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        return extension;
    }

    private Extensions getOrCreate(String mappingTable) {
        this.getOrCreate();
        Extensions extension = this.getOrCreate("related_tables", mappingTable, null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        return extension;
    }

    public boolean has() {
        return this.has("related_tables", "gpkgext_relations", null);
    }

    public boolean has(String mappingTable) {
        return this.has() && this.has("related_tables", mappingTable, null);
    }

    public abstract String getPrimaryKeyColumnName(String var1);

    protected void setContents(UserRelatedTable table) {
        ContentsDao dao = this.geoPackage.getContentsDao();
        Contents contents = null;
        try {
            contents = (Contents)dao.queryForId(table.getTableName());
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve " + Contents.class.getSimpleName() + " for table name: " + table.getTableName(), e);
        }
        if (contents == null) {
            throw new GeoPackageException("No Contents Table exists for table name: " + table.getTableName());
        }
        table.setContents(contents);
    }

    public List<ExtendedRelation> getRelationships() {
        ArrayList<ExtendedRelation> result = null;
        try {
            result = this.extendedRelationsDao.isTableExists() ? this.extendedRelationsDao.queryForAll() : new ArrayList<ExtendedRelation>();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for relationships in related_tables", e);
        }
        return result;
    }

    public ExtendedRelation addRelationship(String baseTableName, String relatedTableName, String mappingTableName, RelationType relationType) {
        return this.addRelationship(baseTableName, relatedTableName, mappingTableName, relationType.getName());
    }

    public ExtendedRelation addRelationship(String baseTableName, String relatedTableName, String mappingTableName, String relationAuthor, String relationName) {
        return this.addRelationship(baseTableName, relatedTableName, mappingTableName, this.buildRelationName(relationAuthor, relationName));
    }

    public ExtendedRelation addRelationship(String baseTableName, String relatedTableName, String mappingTableName, String relationName) {
        UserMappingTable userMappingTable = UserMappingTable.create(mappingTableName);
        ExtendedRelation extendedRelation = this.addRelationship(baseTableName, relatedTableName, userMappingTable, relationName);
        return extendedRelation;
    }

    public ExtendedRelation addRelationship(String baseTableName, String relatedTableName, UserMappingTable userMappingTable, RelationType relationType) {
        return this.addRelationship(baseTableName, relatedTableName, userMappingTable, relationType.getName());
    }

    public ExtendedRelation addRelationship(String baseTableName, String relatedTableName, UserMappingTable userMappingTable, String relationAuthor, String relationName) {
        return this.addRelationship(baseTableName, relatedTableName, userMappingTable, this.buildRelationName(relationAuthor, relationName));
    }

    public ExtendedRelation addRelationship(String baseTableName, String relatedTableName, UserMappingTable userMappingTable, String relationName) {
        this.validateRelationship(baseTableName, relatedTableName, relationName);
        this.createUserMappingTable(userMappingTable);
        ExtendedRelation extendedRelation = new ExtendedRelation();
        extendedRelation.setBaseTableName(baseTableName);
        extendedRelation.setBasePrimaryColumn(this.getPrimaryKeyColumnName(baseTableName));
        extendedRelation.setRelatedTableName(relatedTableName);
        extendedRelation.setRelatedPrimaryColumn(this.getPrimaryKeyColumnName(relatedTableName));
        extendedRelation.setMappingTableName(userMappingTable.getTableName());
        extendedRelation.setRelationName(relationName);
        try {
            this.extendedRelationsDao.create(extendedRelation);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to add relationship '" + relationName + "' between " + baseTableName + " and " + relatedTableName, e);
        }
        return extendedRelation;
    }

    public ExtendedRelation addRelationship(String baseTableName, UserRelatedTable relatedTable, String mappingTableName) {
        UserMappingTable userMappingTable = UserMappingTable.create(mappingTableName);
        return this.addRelationship(baseTableName, relatedTable, userMappingTable);
    }

    public ExtendedRelation addRelationship(String baseTableName, UserRelatedTable relatedTable, UserMappingTable userMappingTable) {
        this.createRelatedTable(relatedTable);
        return this.addRelationship(baseTableName, relatedTable.getTableName(), userMappingTable, relatedTable.getRelationName());
    }

    public ExtendedRelation addFeaturesRelationship(String baseFeaturesTableName, String relatedFeaturesTableName, String mappingTableName) {
        return this.addRelationship(baseFeaturesTableName, relatedFeaturesTableName, mappingTableName, RelationType.FEATURES);
    }

    public ExtendedRelation addFeaturesRelationship(String baseFeaturesTableName, String relatedFeaturesTableName, UserMappingTable userMappingTable) {
        return this.addRelationship(baseFeaturesTableName, relatedFeaturesTableName, userMappingTable, RelationType.FEATURES);
    }

    public ExtendedRelation addMediaRelationship(String baseTableName, MediaTable mediaTable, String mappingTableName) {
        return this.addRelationship(baseTableName, (UserRelatedTable)mediaTable, mappingTableName);
    }

    public ExtendedRelation addMediaRelationship(String baseTableName, MediaTable mediaTable, UserMappingTable userMappingTable) {
        return this.addRelationship(baseTableName, (UserRelatedTable)mediaTable, userMappingTable);
    }

    public ExtendedRelation addSimpleAttributesRelationship(String baseTableName, SimpleAttributesTable simpleAttributesTable, String mappingTableName) {
        return this.addRelationship(baseTableName, (UserRelatedTable)simpleAttributesTable, mappingTableName);
    }

    public ExtendedRelation addSimpleAttributesRelationship(String baseTableName, SimpleAttributesTable simpleAttributesTable, UserMappingTable userMappingTable) {
        return this.addRelationship(baseTableName, (UserRelatedTable)simpleAttributesTable, userMappingTable);
    }

    private void validateRelationship(String baseTableName, String relatedTableName, String relationName) {
        if (!this.geoPackage.isTable(baseTableName)) {
            throw new GeoPackageException("Base Relationship table does not exist: " + baseTableName + ", Relation: " + relationName);
        }
        if (!this.geoPackage.isTable(relatedTableName)) {
            throw new GeoPackageException("Related Relationship table does not exist: " + relatedTableName + ", Relation: " + relationName);
        }
        RelationType relationType = RelationType.fromName(relationName);
        if (relationType != null) {
            this.validateRelationship(baseTableName, relatedTableName, relationType);
        }
    }

    private void validateRelationship(String baseTableName, String relatedTableName, RelationType relationType) {
        if (relationType != null) {
            switch (relationType) {
                case FEATURES: {
                    if (!this.geoPackage.isFeatureTable(baseTableName)) {
                        throw new GeoPackageException("The base table must be a feature table. Relation: " + relationType.getName() + ", Base Table: " + baseTableName + ", Type: " + this.geoPackage.getTableType(baseTableName));
                    }
                    if (this.geoPackage.isFeatureTable(relatedTableName)) break;
                    throw new GeoPackageException("The related table must be a feature table. Relation: " + relationType.getName() + ", Related Table: " + relatedTableName + ", Type: " + this.geoPackage.getTableType(relatedTableName));
                }
                case SIMPLE_ATTRIBUTES: 
                case MEDIA: {
                    if (this.geoPackage.isTableType(relationType.getDataType(), relatedTableName)) break;
                    throw new GeoPackageException("The related table must be a " + relationType.getDataType() + " table. Related Table: " + relatedTableName + ", Type: " + this.geoPackage.getTableType(relatedTableName));
                }
                default: {
                    throw new GeoPackageException("Unsupported relation type: " + (Object)((Object)relationType));
                }
            }
        }
    }

    public boolean createUserMappingTable(String mappingTableName) {
        UserMappingTable userMappingTable = UserMappingTable.create(mappingTableName);
        return this.createUserMappingTable(userMappingTable);
    }

    public boolean createUserMappingTable(UserMappingTable userMappingTable) {
        boolean created = false;
        String userMappingTableName = userMappingTable.getTableName();
        this.getOrCreate(userMappingTableName);
        if (!this.geoPackage.isTable(userMappingTableName)) {
            this.geoPackage.createUserTable(userMappingTable);
            created = true;
        }
        return created;
    }

    public boolean createRelatedTable(UserRelatedTable relatedTable) {
        boolean created = false;
        String relatedTableName = relatedTable.getTableName();
        if (!this.geoPackage.isTable(relatedTableName)) {
            this.geoPackage.createUserTable(relatedTable);
            try {
                Contents contents = new Contents();
                contents.setTableName(relatedTableName);
                contents.setDataTypeString(relatedTable.getDataType());
                contents.setIdentifier(relatedTableName);
                ContentsDao contentsDao = this.geoPackage.getContentsDao();
                contentsDao.create(contents);
                contentsDao.refresh(contents);
                relatedTable.setContents(contents);
            }
            catch (RuntimeException e) {
                this.geoPackage.deleteTableQuietly(relatedTableName);
                throw e;
            }
            catch (SQLException e) {
                this.geoPackage.deleteTableQuietly(relatedTableName);
                throw new GeoPackageException("Failed to create table and metadata: " + relatedTableName, e);
            }
            created = true;
        }
        return created;
    }

    public void removeRelationship(String baseTableName, String relatedTableName, RelationType relationType) {
        this.removeRelationship(baseTableName, relatedTableName, relationType.getName());
    }

    public void removeRelationship(String baseTableName, String relatedTableName, String relationAuthor, String relationName) {
        this.removeRelationship(baseTableName, relatedTableName, this.buildRelationName(relationAuthor, relationName));
    }

    public void removeRelationship(ExtendedRelation extendedRelation) {
        this.removeRelationship(extendedRelation.getBaseTableName(), extendedRelation.getRelatedTableName(), extendedRelation.getRelationName());
    }

    public void removeRelationship(String baseTableName, String relatedTableName, String relationName) {
        try {
            if (this.extendedRelationsDao.isTableExists()) {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("base_table_name", baseTableName);
                fieldValues.put("related_table_name", relatedTableName);
                fieldValues.put("relation_name", relationName);
                List extendedRelations = this.extendedRelationsDao.queryForFieldValues(fieldValues);
                for (ExtendedRelation extendedRelation : extendedRelations) {
                    this.geoPackage.deleteTable(extendedRelation.getMappingTableName());
                }
                this.extendedRelationsDao.delete(extendedRelations);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to remove relationship '" + relationName + "' between " + baseTableName + " and " + relatedTableName, e);
        }
    }

    public void removeExtension() {
        try {
            if (this.extendedRelationsDao.isTableExists()) {
                List extendedRelations = this.extendedRelationsDao.queryForAll();
                for (ExtendedRelation extendedRelation : extendedRelations) {
                    this.geoPackage.deleteTable(extendedRelation.getMappingTableName());
                }
                this.geoPackage.dropTable(this.extendedRelationsDao.getTableName());
            }
            if (this.extensionsDao.isTableExists()) {
                this.extensionsDao.deleteByExtension("related_tables");
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Related Tables extension and table. GeoPackage: " + this.geoPackage.getName(), e);
        }
    }

    public String buildRelationName(String author, String name) {
        return "x-" + author + "_" + name;
    }
}

