/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserCoreConnection;
import mil.nga.geopackage.user.UserCoreResult;
import mil.nga.geopackage.user.UserCoreRow;
import mil.nga.geopackage.user.UserTable;
import mil.nga.sf.GeometryType;

public abstract class UserCoreTableReader<TColumn extends UserColumn, TTable extends UserTable<TColumn>, TRow extends UserCoreRow<TColumn, TTable>, TResult extends UserCoreResult<TColumn, TTable, TRow>> {
    private static final Logger logger = Logger.getLogger(UserCoreTableReader.class.getName());
    public static final String CID = "cid";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String NOT_NULL = "notnull";
    public static final String PK = "pk";
    public static final String DFLT_VALUE = "dflt_value";
    private final String tableName;

    protected UserCoreTableReader(String tableName) {
        this.tableName = tableName;
    }

    protected abstract TTable createTable(String var1, List<TColumn> var2);

    protected abstract TColumn createColumn(TResult var1, int var2, String var3, String var4, Long var5, boolean var6, int var7, boolean var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TTable readTable(UserCoreConnection<TColumn, TTable, TRow, TResult> db) {
        ArrayList<TColumn> columnList = new ArrayList<TColumn>();
        try (TResult result = db.rawQuery("PRAGMA table_info(" + CoreSQLUtils.quoteWrap(this.tableName) + ")", null);){
            while (result.moveToNext()) {
                String maxString;
                int maxStart;
                int index = result.getInt(result.getColumnIndex(CID));
                String name = result.getString(result.getColumnIndex(NAME));
                String type = result.getString(result.getColumnIndex(TYPE));
                boolean notNull = result.getInt(result.getColumnIndex(NOT_NULL)) == 1;
                boolean primaryKey = result.getInt(result.getColumnIndex(PK)) == 1;
                Long max = null;
                if (type != null && type.endsWith(")") && (maxStart = type.indexOf("(")) > -1 && !(maxString = type.substring(maxStart + 1, type.length() - 1)).isEmpty()) {
                    try {
                        max = Long.valueOf(maxString);
                        type = type.substring(0, maxStart);
                    }
                    catch (NumberFormatException e) {
                        logger.log(Level.WARNING, "Failed to parse type max from type: " + type, e);
                    }
                }
                int defaultValueIndex = result.getColumnIndex(DFLT_VALUE);
                TColumn column = this.createColumn(result, index, name, type, max, notNull, defaultValueIndex, primaryKey);
                columnList.add(column);
            }
        }
        if (columnList.isEmpty()) {
            throw new GeoPackageException("Table does not exist: " + this.tableName);
        }
        return this.createTable(this.tableName, columnList);
    }

    public GeoPackageDataType getDataType(String type) {
        GeoPackageDataType dataType = null;
        try {
            dataType = GeoPackageDataType.fromName(type);
        }
        catch (IllegalArgumentException dataTypeException) {
            try {
                GeometryType.fromName((String)type);
                dataType = GeoPackageDataType.BLOB;
            }
            catch (IllegalArgumentException geometryException) {
                throw new GeoPackageException("Unsupported column data type " + type, dataTypeException);
            }
        }
        return dataType;
    }
}

