/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import com.j256.ormlite.support.ConnectionSource;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageDaoManager;
import mil.nga.geopackage.db.GeoPackageDataType;

public abstract class GeoPackageCoreConnection
implements Closeable {
    protected final ConnectionSource connectionSource;

    protected GeoPackageCoreConnection(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public abstract void execSQL(String var1);

    public abstract int delete(String var1, String var2, String[] var3);

    public abstract int count(String var1, String var2, String[] var3);

    public abstract Integer min(String var1, String var2, String var3, String[] var4);

    public abstract Integer max(String var1, String var2, String var3, String[] var4);

    @Override
    public void close() {
        GeoPackageDaoManager.unregisterDaos(this.connectionSource);
        this.connectionSource.closeQuietly();
    }

    public boolean tableExists(String tableName) {
        return this.count("sqlite_master", "tbl_name = ?", new String[]{tableName}) > 0;
    }

    public abstract boolean columnExists(String var1, String var2);

    public void addColumn(String tableName, String columnName, String columnDef) {
        this.execSQL("ALTER TABLE " + CoreSQLUtils.quoteWrap(tableName) + " ADD COLUMN " + CoreSQLUtils.quoteWrap(columnName) + " " + columnDef + ";");
    }

    public Object querySingleResult(String sql, String[] args) {
        return this.querySingleResult(sql, args, 0);
    }

    public <T> T querySingleTypedResult(String sql, String[] args) {
        Object result = this.querySingleResult(sql, args);
        return (T)result;
    }

    public Object querySingleResult(String sql, String[] args, GeoPackageDataType dataType) {
        return this.querySingleResult(sql, args, 0, dataType);
    }

    public <T> T querySingleTypedResult(String sql, String[] args, GeoPackageDataType dataType) {
        Object result = this.querySingleResult(sql, args, dataType);
        return (T)result;
    }

    public Object querySingleResult(String sql, String[] args, int column) {
        return this.querySingleResult(sql, args, column, null);
    }

    public <T> T querySingleTypedResult(String sql, String[] args, int column) {
        Object result = this.querySingleResult(sql, args, column);
        return (T)result;
    }

    public abstract Object querySingleResult(String var1, String[] var2, int var3, GeoPackageDataType var4);

    public <T> T querySingleTypedResult(String sql, String[] args, int column, GeoPackageDataType dataType) {
        Object result = this.querySingleResult(sql, args, column, dataType);
        return (T)result;
    }

    public List<Object> querySingleColumnResults(String sql, String[] args) {
        return this.querySingleColumnResults(sql, args, 0, null, null);
    }

    public <T> List<T> querySingleColumnTypedResults(String sql, String[] args) {
        List<Object> result = this.querySingleColumnResults(sql, args);
        return result;
    }

    public List<Object> querySingleColumnResults(String sql, String[] args, GeoPackageDataType dataType) {
        return this.querySingleColumnResults(sql, args, 0, dataType, null);
    }

    public <T> List<T> querySingleColumnTypedResults(String sql, String[] args, GeoPackageDataType dataType) {
        List<Object> result = this.querySingleColumnResults(sql, args, dataType);
        return result;
    }

    public List<Object> querySingleColumnResults(String sql, String[] args, int column) {
        return this.querySingleColumnResults(sql, args, column, null, null);
    }

    public <T> List<T> querySingleColumnTypedResults(String sql, String[] args, int column) {
        List<Object> result = this.querySingleColumnResults(sql, args, column);
        return result;
    }

    public List<Object> querySingleColumnResults(String sql, String[] args, int column, GeoPackageDataType dataType) {
        return this.querySingleColumnResults(sql, args, column, dataType, null);
    }

    public <T> List<T> querySingleColumnTypedResults(String sql, String[] args, int column, GeoPackageDataType dataType) {
        List<Object> result = this.querySingleColumnResults(sql, args, column, dataType);
        return result;
    }

    public List<Object> querySingleColumnResults(String sql, String[] args, int column, Integer limit) {
        return this.querySingleColumnResults(sql, args, column, null, limit);
    }

    public <T> List<T> querySingleColumnTypedResults(String sql, String[] args, int column, Integer limit) {
        List<Object> result = this.querySingleColumnResults(sql, args, column, limit);
        return result;
    }

    public abstract List<Object> querySingleColumnResults(String var1, String[] var2, int var3, GeoPackageDataType var4, Integer var5);

    public <T> List<T> querySingleColumnTypedResults(String sql, String[] args, int column, GeoPackageDataType dataType, Integer limit) {
        List<Object> result = this.querySingleColumnResults(sql, args, column, dataType, limit);
        return result;
    }

    public List<List<Object>> queryResults(String sql, String[] args) {
        return this.queryResults(sql, args, null, null);
    }

    public <T> List<List<T>> queryTypedResults(String sql, String[] args) {
        List<List<T>> result = this.queryResults(sql, args);
        return result;
    }

    public List<List<Object>> queryResults(String sql, String[] args, GeoPackageDataType[] dataTypes) {
        return this.queryResults(sql, args, dataTypes, null);
    }

    public <T> List<List<T>> queryTypedResults(String sql, String[] args, GeoPackageDataType[] dataTypes) {
        List<List<T>> result = this.queryResults(sql, args, dataTypes);
        return result;
    }

    public List<Object> querySingleRowResults(String sql, String[] args) {
        return this.querySingleRowResults(sql, args, null);
    }

    public <T> List<T> querySingleRowTypedResults(String sql, String[] args) {
        List<Object> result = this.querySingleRowResults(sql, args);
        return result;
    }

    public List<Object> querySingleRowResults(String sql, String[] args, GeoPackageDataType[] dataTypes) {
        List<List<Object>> results = this.queryResults(sql, args, dataTypes, 1);
        List<Object> singleRow = null;
        if (!results.isEmpty()) {
            singleRow = results.get(0);
        }
        return singleRow;
    }

    public <T> List<T> querySingleRowTypedResults(String sql, String[] args, GeoPackageDataType[] dataTypes) {
        List<Object> result = this.querySingleRowResults(sql, args, dataTypes);
        return result;
    }

    public List<List<Object>> queryResults(String sql, String[] args, Integer limit) {
        return this.queryResults(sql, args, null, limit);
    }

    public <T> List<List<T>> queryTypedResults(String sql, String[] args, Integer limit) {
        List<List<T>> result = this.queryResults(sql, args, limit);
        return result;
    }

    public abstract List<List<Object>> queryResults(String var1, String[] var2, GeoPackageDataType[] var3, Integer var4);

    public <T> List<List<T>> queryTypedResults(String sql, String[] args, GeoPackageDataType[] dataTypes, Integer limit) {
        List<List<T>> result = this.queryResults(sql, args, dataTypes, limit);
        return result;
    }

    public void setApplicationId() {
        this.setApplicationId("GPKG");
    }

    public void setApplicationId(String applicationId) {
        int applicationIdInt = ByteBuffer.wrap(applicationId.getBytes()).asIntBuffer().get();
        this.execSQL(String.format("PRAGMA application_id = %d;", applicationIdInt));
    }

    public String getApplicationId() {
        String applicationId = null;
        Integer applicationIdObject = (Integer)this.querySingleTypedResult("PRAGMA application_id", null, GeoPackageDataType.MEDIUMINT);
        if (applicationIdObject != null) {
            try {
                applicationId = new String(ByteBuffer.allocate(4).putInt(applicationIdObject).array(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new GeoPackageException("Unexpected application id character encoding", e);
            }
        }
        return applicationId;
    }

    public void setUserVersion() {
        this.setUserVersion(10201);
    }

    public void setUserVersion(int userVersion) {
        this.execSQL(String.format("PRAGMA user_version = %d;", userVersion));
    }

    public int getUserVersion() {
        int userVersion = -1;
        Integer userVersionObject = (Integer)this.querySingleTypedResult("PRAGMA user_version", null, GeoPackageDataType.MEDIUMINT);
        if (userVersionObject != null) {
            userVersion = userVersionObject;
        }
        return userVersion;
    }
}

