/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import java.sql.SQLException;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.extension.CrsWktExtension;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.MetadataExtension;
import mil.nga.geopackage.extension.NGAExtensions;
import mil.nga.geopackage.extension.RTreeIndexCoreExtension;
import mil.nga.geopackage.extension.SchemaExtension;
import mil.nga.geopackage.extension.coverage.CoverageDataCore;
import mil.nga.geopackage.extension.coverage.GriddedCoverageDao;
import mil.nga.geopackage.extension.coverage.GriddedTileDao;
import mil.nga.geopackage.extension.related.RelatedTablesCoreExtension;
import mil.nga.geopackage.metadata.reference.MetadataReferenceDao;
import mil.nga.geopackage.schema.columns.DataColumnsDao;

public class GeoPackageExtensions {
    public static void deleteTableExtensions(GeoPackageCore geoPackage, String table) {
        NGAExtensions.deleteTableExtensions(geoPackage, table);
        GeoPackageExtensions.deleteRTreeSpatialIndex(geoPackage, table);
        GeoPackageExtensions.deleteRelatedTables(geoPackage, table);
        GeoPackageExtensions.deleteGriddedCoverage(geoPackage, table);
        GeoPackageExtensions.deleteSchema(geoPackage, table);
        GeoPackageExtensions.deleteMetadata(geoPackage, table);
        GeoPackageExtensions.delete(geoPackage, table);
    }

    public static void deleteExtensions(GeoPackageCore geoPackage) {
        NGAExtensions.deleteExtensions(geoPackage);
        GeoPackageExtensions.deleteRTreeSpatialIndexExtension(geoPackage);
        GeoPackageExtensions.deleteRelatedTablesExtension(geoPackage);
        GeoPackageExtensions.deleteGriddedCoverageExtension(geoPackage);
        GeoPackageExtensions.deleteSchemaExtension(geoPackage);
        GeoPackageExtensions.deleteMetadataExtension(geoPackage);
        GeoPackageExtensions.deleteCrsWktExtension(geoPackage);
        GeoPackageExtensions.delete(geoPackage);
    }

    private static void delete(GeoPackageCore geoPackage, String table) {
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table extensions. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    private static void delete(GeoPackageCore geoPackage) {
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (extensionsDao.isTableExists()) {
                geoPackage.dropTable(extensionsDao.getTableName());
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete all extensions. GeoPackage: " + geoPackage.getName(), e);
        }
    }

    public static void deleteRTreeSpatialIndex(GeoPackageCore geoPackage, String table) {
        RTreeIndexCoreExtension rTreeIndexExtension = GeoPackageExtensions.getRTreeIndexExtension(geoPackage);
        if (rTreeIndexExtension.has(table)) {
            rTreeIndexExtension.delete(table);
        }
    }

    public static void deleteRTreeSpatialIndexExtension(GeoPackageCore geoPackage) {
        RTreeIndexCoreExtension rTreeIndexExtension = GeoPackageExtensions.getRTreeIndexExtension(geoPackage);
        if (rTreeIndexExtension.has()) {
            rTreeIndexExtension.deleteAll();
        }
    }

    private static RTreeIndexCoreExtension getRTreeIndexExtension(GeoPackageCore geoPackage) {
        return new RTreeIndexCoreExtension(geoPackage){

            @Override
            public void createMinYFunction() {
            }

            @Override
            public void createMinXFunction() {
            }

            @Override
            public void createMaxYFunction() {
            }

            @Override
            public void createMaxXFunction() {
            }

            @Override
            public void createIsEmptyFunction() {
            }
        };
    }

    public static void deleteRelatedTables(GeoPackageCore geoPackage, String table) {
        RelatedTablesCoreExtension relatedTablesExtension = GeoPackageExtensions.getRelatedTableExtension(geoPackage);
        if (relatedTablesExtension.has()) {
            relatedTablesExtension.removeRelationships(table);
        }
    }

    public static void deleteRelatedTablesExtension(GeoPackageCore geoPackage) {
        RelatedTablesCoreExtension relatedTablesExtension = GeoPackageExtensions.getRelatedTableExtension(geoPackage);
        if (relatedTablesExtension.has()) {
            relatedTablesExtension.removeExtension();
        }
    }

    private static RelatedTablesCoreExtension getRelatedTableExtension(GeoPackageCore geoPackage) {
        return new RelatedTablesCoreExtension(geoPackage){

            @Override
            public String getPrimaryKeyColumnName(String tableName) {
                return null;
            }
        };
    }

    public static void deleteGriddedCoverage(GeoPackageCore geoPackage, String table) {
        if (geoPackage.isTableType(ContentsDataType.GRIDDED_COVERAGE, table)) {
            GriddedTileDao griddedTileDao = geoPackage.getGriddedTileDao();
            GriddedCoverageDao griddedCoverageDao = geoPackage.getGriddedCoverageDao();
            ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
            try {
                if (griddedTileDao.isTableExists()) {
                    griddedTileDao.delete(table);
                }
                if (griddedCoverageDao.isTableExists()) {
                    griddedCoverageDao.delete(table);
                }
                if (extensionsDao.isTableExists()) {
                    extensionsDao.deleteByExtension(CoverageDataCore.EXTENSION_NAME, table);
                }
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to delete Table Index. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
            }
        }
    }

    public static void deleteGriddedCoverageExtension(GeoPackageCore geoPackage) {
        List<String> coverageTables = geoPackage.getTables(ContentsDataType.GRIDDED_COVERAGE);
        for (String table : coverageTables) {
            geoPackage.deleteTable(table);
        }
        GriddedTileDao griddedTileDao = geoPackage.getGriddedTileDao();
        GriddedCoverageDao griddedCoverageDao = geoPackage.getGriddedCoverageDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (griddedTileDao.isTableExists()) {
                geoPackage.dropTable(griddedTileDao.getTableName());
            }
            if (griddedCoverageDao.isTableExists()) {
                geoPackage.dropTable(griddedCoverageDao.getTableName());
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(CoverageDataCore.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Gridded Coverage extension and tables. GeoPackage: " + geoPackage.getName(), e);
        }
    }

    public static void deleteSchema(GeoPackageCore geoPackage, String table) {
        DataColumnsDao dataColumnsDao = geoPackage.getDataColumnsDao();
        try {
            if (dataColumnsDao.isTableExists()) {
                dataColumnsDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Schema extension. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public static void deleteSchemaExtension(GeoPackageCore geoPackage) {
        SchemaExtension schemaExtension = new SchemaExtension(geoPackage);
        if (schemaExtension.has()) {
            schemaExtension.removeExtension();
        }
    }

    public static void deleteMetadata(GeoPackageCore geoPackage, String table) {
        MetadataReferenceDao metadataReferenceDao = geoPackage.getMetadataReferenceDao();
        try {
            if (metadataReferenceDao.isTableExists()) {
                metadataReferenceDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Metadata extension. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public static void deleteMetadataExtension(GeoPackageCore geoPackage) {
        MetadataExtension metadataExtension = new MetadataExtension(geoPackage);
        if (metadataExtension.has()) {
            metadataExtension.removeExtension();
        }
    }

    public static void deleteCrsWktExtension(GeoPackageCore geoPackage) {
        CrsWktExtension crsWktExtension = new CrsWktExtension(geoPackage);
        if (crsWktExtension.has()) {
            crsWktExtension.removeExtension();
        }
    }
}

