/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.contents.ContentsIdExtension;
import mil.nga.geopackage.extension.index.FeatureTableCoreIndex;
import mil.nga.geopackage.extension.index.GeometryIndexDao;
import mil.nga.geopackage.extension.index.TableIndexDao;
import mil.nga.geopackage.extension.link.FeatureTileLinkDao;
import mil.nga.geopackage.extension.link.FeatureTileTableCoreLinker;
import mil.nga.geopackage.extension.properties.PropertiesCoreExtension;
import mil.nga.geopackage.extension.related.RelatedTablesCoreExtension;
import mil.nga.geopackage.extension.scale.TileScalingDao;
import mil.nga.geopackage.extension.scale.TileTableScaling;
import mil.nga.geopackage.extension.style.FeatureCoreStyleExtension;

public class NGAExtensions {
    public static void deleteTableExtensions(GeoPackageCore geoPackage, String table) {
        NGAExtensions.deleteGeometryIndex(geoPackage, table);
        NGAExtensions.deleteFeatureTileLink(geoPackage, table);
        NGAExtensions.deleteTileScaling(geoPackage, table);
        NGAExtensions.deleteProperties(geoPackage, table);
        NGAExtensions.deleteFeatureStyle(geoPackage, table);
        NGAExtensions.deleteContentsId(geoPackage, table);
    }

    public static void deleteExtensions(GeoPackageCore geoPackage) {
        NGAExtensions.deleteGeometryIndexExtension(geoPackage);
        NGAExtensions.deleteFeatureTileLinkExtension(geoPackage);
        NGAExtensions.deleteTileScalingExtension(geoPackage);
        NGAExtensions.deletePropertiesExtension(geoPackage);
        NGAExtensions.deleteFeatureStyleExtension(geoPackage);
        NGAExtensions.deleteContentsIdExtension(geoPackage);
    }

    public static void deleteGeometryIndex(GeoPackageCore geoPackage, String table) {
        TableIndexDao tableIndexDao = geoPackage.getTableIndexDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (tableIndexDao.isTableExists()) {
                tableIndexDao.deleteByIdCascade(table);
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(FeatureTableCoreIndex.EXTENSION_NAME, table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table Index. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public static void deleteGeometryIndexExtension(GeoPackageCore geoPackage) {
        GeometryIndexDao geometryIndexDao = geoPackage.getGeometryIndexDao();
        TableIndexDao tableIndexDao = geoPackage.getTableIndexDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (geometryIndexDao.isTableExists()) {
                geoPackage.dropTable(geometryIndexDao.getTableName());
            }
            if (tableIndexDao.isTableExists()) {
                geoPackage.dropTable(tableIndexDao.getTableName());
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(FeatureTableCoreIndex.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table Index extension and tables. GeoPackage: " + geoPackage.getName(), e);
        }
    }

    public static void deleteFeatureTileLink(GeoPackageCore geoPackage, String table) {
        FeatureTileLinkDao featureTileLinkDao = geoPackage.getFeatureTileLinkDao();
        try {
            if (featureTileLinkDao.isTableExists()) {
                featureTileLinkDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Feature Tile Link. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public static void deleteFeatureTileLinkExtension(GeoPackageCore geoPackage) {
        FeatureTileLinkDao featureTileLinkDao = geoPackage.getFeatureTileLinkDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (featureTileLinkDao.isTableExists()) {
                geoPackage.dropTable(featureTileLinkDao.getTableName());
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(FeatureTileTableCoreLinker.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Feature Tile Link extension and table. GeoPackage: " + geoPackage.getName(), e);
        }
    }

    public static void deleteTileScaling(GeoPackageCore geoPackage, String table) {
        TileScalingDao tileScalingDao = geoPackage.getTileScalingDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (tileScalingDao.isTableExists()) {
                tileScalingDao.deleteById(table);
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(TileTableScaling.EXTENSION_NAME, table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Tile Scaling. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public static void deleteTileScalingExtension(GeoPackageCore geoPackage) {
        TileScalingDao tileScalingDao = geoPackage.getTileScalingDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (tileScalingDao.isTableExists()) {
                geoPackage.dropTable(tileScalingDao.getTableName());
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(TileTableScaling.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Tile Scaling extension and table. GeoPackage: " + geoPackage.getName(), e);
        }
    }

    public static void deleteProperties(GeoPackageCore geoPackage, String table) {
        if (table.equalsIgnoreCase(PropertiesCoreExtension.TABLE_NAME)) {
            NGAExtensions.deletePropertiesExtension(geoPackage);
        }
    }

    public static void deletePropertiesExtension(GeoPackageCore geoPackage) {
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        if (geoPackage.isTable(PropertiesCoreExtension.TABLE_NAME)) {
            ContentsDao contentsDao = geoPackage.getContentsDao();
            contentsDao.deleteTable(PropertiesCoreExtension.TABLE_NAME);
        }
        try {
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(PropertiesCoreExtension.EXTENSION_NAME, PropertiesCoreExtension.TABLE_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Properties extension. GeoPackage: " + geoPackage.getName(), e);
        }
    }

    public static void deleteFeatureStyle(GeoPackageCore geoPackage, String table) {
        FeatureCoreStyleExtension featureStyleExtension = NGAExtensions.getFeatureStyleExtension(geoPackage);
        if (featureStyleExtension.has(table)) {
            featureStyleExtension.deleteRelationships(table);
        }
    }

    public static void deleteFeatureStyleExtension(GeoPackageCore geoPackage) {
        FeatureCoreStyleExtension featureStyleExtension = NGAExtensions.getFeatureStyleExtension(geoPackage);
        if (featureStyleExtension.has()) {
            featureStyleExtension.removeExtension();
        }
    }

    private static FeatureCoreStyleExtension getFeatureStyleExtension(GeoPackageCore geoPackage) {
        RelatedTablesCoreExtension relatedTables = new RelatedTablesCoreExtension(geoPackage){

            @Override
            public String getPrimaryKeyColumnName(String tableName) {
                return null;
            }
        };
        return new FeatureCoreStyleExtension(geoPackage, relatedTables){};
    }

    public static void deleteContentsId(GeoPackageCore geoPackage, String table) {
        ContentsIdExtension contentsIdExtension = new ContentsIdExtension(geoPackage);
        if (contentsIdExtension.has()) {
            contentsIdExtension.delete(table);
        }
    }

    public static void deleteContentsIdExtension(GeoPackageCore geoPackage) {
        ContentsIdExtension contentsIdExtension = new ContentsIdExtension(geoPackage);
        if (contentsIdExtension.has()) {
            contentsIdExtension.removeExtension();
        }
    }
}

