/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.property.GeoPackageProperties;

public class SchemaExtension
extends BaseExtension {
    public static final String NAME = "schema";
    public static final String EXTENSION_NAME = "gpkg_schema";
    public static final String DEFINITION = GeoPackageProperties.getProperty("geopackage.extensions", "schema");

    public SchemaExtension(GeoPackageCore geoPackage) {
        super(geoPackage);
    }

    public Extensions getOrCreate() {
        Extensions extension = this.getOrCreate(EXTENSION_NAME, null, null, DEFINITION, ExtensionScopeType.READ_WRITE);
        return extension;
    }

    public boolean has() {
        boolean exists = this.has(EXTENSION_NAME, null, null);
        return exists;
    }

    public void removeExtension() {
        if (this.geoPackage.isTable("gpkg_data_columns")) {
            this.geoPackage.dropTable("gpkg_data_columns");
        }
        if (this.geoPackage.isTable("gpkg_data_column_constraints")) {
            this.geoPackage.dropTable("gpkg_data_column_constraints");
        }
        try {
            if (this.extensionsDao.isTableExists()) {
                this.extensionsDao.deleteByExtension(EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Schema extension. GeoPackage: " + this.geoPackage.getName(), e);
        }
    }
}

