/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.columns;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.features.columns.GeometryColumnsSqlMmDao;
import mil.nga.geopackage.schema.TableColumnKey;
import mil.nga.sf.GeometryType;
import mil.nga.sf.proj.Projection;

@DatabaseTable(tableName="st_geometry_columns", daoClass=GeometryColumnsSqlMmDao.class)
public class GeometryColumnsSqlMm {
    public static final String TABLE_NAME = "st_geometry_columns";
    public static final String COLUMN_TABLE_NAME = "table_name";
    public static final String COLUMN_COLUMN_NAME = "column_name";
    public static final String COLUMN_ID_1 = "table_name";
    public static final String COLUMN_ID_2 = "column_name";
    public static final String COLUMN_GEOMETRY_TYPE_NAME = "geometry_type_name";
    public static final String COLUMN_GEOMETRY_TYPE_NAME_PREFIX = "ST_";
    public static final String COLUMN_SRS_ID = "srs_id";
    public static final String COLUMN_SRS_NAME = "srs_name";
    @DatabaseField(columnName="table_name", canBeNull=false, unique=true, foreign=true, foreignAutoRefresh=true)
    private Contents contents;
    @DatabaseField(columnName="table_name", id=true, canBeNull=false, uniqueCombo=true, readOnly=true)
    private String tableName;
    @DatabaseField(columnName="column_name", canBeNull=false, uniqueCombo=true)
    private String columnName;
    @DatabaseField(columnName="geometry_type_name", canBeNull=false)
    private String geometryTypeName;
    @DatabaseField(columnName="srs_id", canBeNull=false, foreign=true, foreignAutoRefresh=true)
    private SpatialReferenceSystem srs;
    @DatabaseField(columnName="srs_id", canBeNull=false, readOnly=true)
    private long srsId;
    @DatabaseField(columnName="srs_name", canBeNull=false)
    private String srsName;

    public GeometryColumnsSqlMm() {
    }

    public GeometryColumnsSqlMm(GeometryColumnsSqlMm geometryColumns) {
        this.contents = geometryColumns.contents;
        this.tableName = geometryColumns.tableName;
        this.columnName = geometryColumns.columnName;
        this.geometryTypeName = geometryColumns.geometryTypeName;
        this.srs = geometryColumns.srs;
        this.srsId = geometryColumns.srsId;
        this.srsName = geometryColumns.srsName;
    }

    public TableColumnKey getId() {
        return new TableColumnKey(this.tableName, this.columnName);
    }

    public void setId(TableColumnKey id) {
        this.tableName = id.getTableName();
        this.columnName = id.getColumnName();
    }

    public Contents getContents() {
        return this.contents;
    }

    public void setContents(Contents contents) {
        this.contents = contents;
        if (contents != null) {
            ContentsDataType dataType = contents.getDataType();
            if (dataType == null || dataType != ContentsDataType.FEATURES) {
                throw new GeoPackageException("The " + Contents.class.getSimpleName() + " of a " + GeometryColumnsSqlMm.class.getSimpleName() + " must have a data type of " + ContentsDataType.FEATURES.getName());
            }
            this.tableName = contents.getId();
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public GeometryType getGeometryType() {
        return GeometryType.fromName((String)this.geometryTypeName.substring(COLUMN_GEOMETRY_TYPE_NAME_PREFIX.length(), this.geometryTypeName.length()));
    }

    public void setGeometryType(GeometryType geometryType) {
        this.geometryTypeName = COLUMN_GEOMETRY_TYPE_NAME_PREFIX + geometryType.getName();
    }

    public String getGeometryTypeName() {
        return this.geometryTypeName;
    }

    public SpatialReferenceSystem getSrs() {
        return this.srs;
    }

    public void setSrs(SpatialReferenceSystem srs) {
        this.srs = srs;
        if (srs != null) {
            this.srsId = srs.getId();
            this.srsName = srs.getSrsName();
        }
    }

    public long getSrsId() {
        return this.srsId;
    }

    public String getSrsName() {
        return this.srsName;
    }

    public Projection getProjection() {
        return this.getSrs().getProjection();
    }
}

