/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.user;

import java.util.List;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.user.UserTable;
import mil.nga.sf.GeometryType;

public class FeatureTable
extends UserTable<FeatureColumn> {
    private final int geometryIndex;

    public FeatureTable(String tableName, List<FeatureColumn> columns) {
        super(tableName, columns);
        Integer geometry = null;
        for (FeatureColumn column : columns) {
            if (!column.isGeometry()) continue;
            this.duplicateCheck(column.getIndex(), geometry, GeometryType.GEOMETRY.name());
            geometry = column.getIndex();
        }
        this.missingCheck(geometry, GeometryType.GEOMETRY.name());
        this.geometryIndex = geometry;
    }

    @Override
    public String getDataType() {
        return ContentsDataType.FEATURES.getName();
    }

    public int getGeometryColumnIndex() {
        return this.geometryIndex;
    }

    public FeatureColumn getGeometryColumn() {
        return (FeatureColumn)this.getColumn(this.geometryIndex);
    }

    @Override
    protected void validateContents(Contents contents) {
        ContentsDataType dataType = contents.getDataType();
        if (dataType == null || dataType != ContentsDataType.FEATURES) {
            throw new GeoPackageException("The " + Contents.class.getSimpleName() + " of a " + FeatureTable.class.getSimpleName() + " must have a data type of " + ContentsDataType.FEATURES.getName());
        }
    }
}

