/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageDataType;

public abstract class UserColumn
implements Comparable<UserColumn> {
    private final int index;
    private final String name;
    private final Long max;
    private final boolean notNull;
    private final Object defaultValue;
    private final boolean primaryKey;
    private final GeoPackageDataType dataType;

    protected UserColumn(int index, String name, GeoPackageDataType dataType, Long max, boolean notNull, Object defaultValue, boolean primaryKey) {
        this.index = index;
        this.name = name;
        this.max = max;
        this.notNull = notNull;
        this.defaultValue = defaultValue;
        this.primaryKey = primaryKey;
        this.dataType = dataType;
        this.validateMax();
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNamed(String name) {
        return this.name.equals(name);
    }

    public Long getMax() {
        return this.max;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public GeoPackageDataType getDataType() {
        return this.dataType;
    }

    public String getTypeName() {
        String type = null;
        if (this.dataType != null) {
            type = this.dataType.name();
        }
        return type;
    }

    @Override
    public int compareTo(UserColumn another) {
        return this.index - another.index;
    }

    private void validateMax() {
        if (this.max != null) {
            if (this.dataType == null) {
                throw new GeoPackageException("Column max is only supported for data typed columns. column: " + this.name + ", max: " + this.max);
            }
            if (this.dataType != GeoPackageDataType.TEXT && this.dataType != GeoPackageDataType.BLOB) {
                throw new GeoPackageException("Column max is only supported for " + GeoPackageDataType.TEXT.name() + " and " + GeoPackageDataType.BLOB.name() + " columns. column: " + this.name + ", max: " + this.max + ", type: " + this.dataType.name());
            }
        }
    }
}

