package mil.nga.geopackage.user;

import mil.nga.geopackage.db.Result;

/**
 * Abstract User Cursor
 * 
 * @param <TColumn>
 *            column type
 * @param <TTable>
 *            table type
 * @param <TRow>
 *            row type
 * 
 * @author osbornb
 */
public interface UserCoreResult<TColumn extends UserColumn, TTable extends UserTable<TColumn>, TRow extends UserCoreRow<TColumn, TTable>>
		extends Result {

	/**
	 * Get a row using the column types and values
	 * 
	 * @param columnTypes
	 *            column types
	 * @param values
	 *            values
	 * @return row
	 */
	public TRow getRow(int[] columnTypes, Object[] values);

	/**
	 * Get the value for the column
	 * 
	 * @param column
	 *            column
	 * @return value
	 */
	public Object getValue(TColumn column);

	/**
	 * Get the table
	 * 
	 * @return table
	 */
	public TTable getTable();

	/**
	 * Get the row at the current cursor position
	 * 
	 * @return row
	 */
	public TRow getRow();

	/**
	 * Get the count of results
	 * 
	 * @return count
	 */
	public int getCount();

}
