/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db.master;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.master.SQLiteMasterColumn;
import mil.nga.geopackage.db.master.SQLiteMasterQuery;
import mil.nga.geopackage.db.master.SQLiteMasterType;
import mil.nga.geopackage.db.table.ConstraintParser;
import mil.nga.geopackage.db.table.TableConstraints;

public class SQLiteMaster {
    public static final String TABLE_NAME = "sqlite_master";
    private final List<List<Object>> results;
    private final Map<SQLiteMasterColumn, Integer> columns = new HashMap<SQLiteMasterColumn, Integer>();
    private final int count;

    private SQLiteMaster(List<List<Object>> results, SQLiteMasterColumn[] columns) {
        if (columns != null) {
            this.results = results;
            this.count = results.size();
            for (int i = 0; i < columns.length; ++i) {
                this.columns.put(columns[i], i);
            }
        } else {
            this.results = new ArrayList<List<Object>>();
            this.count = ((Number)results.get(0).get(0)).intValue();
        }
    }

    public int count() {
        return this.count;
    }

    public Set<SQLiteMasterColumn> columns() {
        return this.columns.keySet();
    }

    public SQLiteMasterType getType(int row) {
        return SQLiteMasterType.valueOf(this.getTypeString(row).toUpperCase());
    }

    public String getTypeString(int row) {
        return (String)this.getValue(row, SQLiteMasterColumn.TYPE);
    }

    public String getName(int row) {
        return (String)this.getValue(row, SQLiteMasterColumn.NAME);
    }

    public String getTableName(int row) {
        return (String)this.getValue(row, SQLiteMasterColumn.TBL_NAME);
    }

    public Long getRootpage(int row) {
        return (Long)this.getValue(row, SQLiteMasterColumn.ROOTPAGE);
    }

    public String getSql(int row) {
        return (String)this.getValue(row, SQLiteMasterColumn.SQL);
    }

    public Object getValue(int row, SQLiteMasterColumn column) {
        return this.getValue(this.getRow(row), column);
    }

    public List<Object> getRow(int row) {
        if (row < 0 || row >= this.results.size()) {
            String message = this.results.isEmpty() ? "Results are empty" : "Row index: " + row + ", not within range 0 to " + (this.results.size() - 1);
            throw new IndexOutOfBoundsException(message);
        }
        return this.results.get(row);
    }

    public Object getValue(List<Object> row, SQLiteMasterColumn column) {
        return row.get(this.getColumnIndex(column));
    }

    public int getColumnIndex(SQLiteMasterColumn column) {
        Integer index = this.columns.get((Object)column);
        if (index == null) {
            throw new IndexOutOfBoundsException("Column does not exist in row values: " + (Object)((Object)column));
        }
        return index;
    }

    public TableConstraints getConstraints(int row) {
        String sql;
        TableConstraints constraints = new TableConstraints();
        if (this.getType(row) == SQLiteMasterType.TABLE && (sql = this.getSql(row)) != null) {
            constraints = ConstraintParser.getConstraints(sql);
        }
        return constraints;
    }

    public static SQLiteMasterColumn[] columns(SQLiteMasterColumn ... columns) {
        return columns;
    }

    public static SQLiteMasterType[] types(SQLiteMasterType ... types) {
        return types;
    }

    public static int count(GeoPackageCoreConnection db) {
        return SQLiteMaster.count(db, SQLiteMaster.types(new SQLiteMasterType[0]), SQLiteMasterQuery.create());
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db) {
        return SQLiteMaster.query(db, SQLiteMasterQuery.create());
    }

    public static int count(GeoPackageCoreConnection db, String tableName) {
        return SQLiteMaster.count(db, SQLiteMaster.types(new SQLiteMasterType[0]), tableName);
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, String tableName) {
        return SQLiteMaster.query(db, SQLiteMasterColumn.values(), SQLiteMaster.types(new SQLiteMasterType[0]), tableName);
    }

    public static SQLiteMaster queryForColumns(GeoPackageCoreConnection db, Collection<SQLiteMasterColumn> columns) {
        return SQLiteMaster.queryForColumns(db, columns, null);
    }

    public static SQLiteMaster queryForColumns(GeoPackageCoreConnection db, Collection<SQLiteMasterColumn> columns, String tableName) {
        return SQLiteMaster.query(db, columns.toArray(new SQLiteMasterColumn[0]), SQLiteMaster.types(new SQLiteMasterType[0]), tableName);
    }

    public static int countByType(GeoPackageCoreConnection db, SQLiteMasterType type) {
        return SQLiteMaster.countByType(db, type, null);
    }

    public static SQLiteMaster queryByType(GeoPackageCoreConnection db, SQLiteMasterType type) {
        return SQLiteMaster.queryByType(db, type, null);
    }

    public static int countByType(GeoPackageCoreConnection db, Collection<SQLiteMasterType> types) {
        return SQLiteMaster.countByType(db, types, null);
    }

    public static SQLiteMaster queryByType(GeoPackageCoreConnection db, Collection<SQLiteMasterType> types) {
        return SQLiteMaster.queryByType(db, types, null);
    }

    public static int countByType(GeoPackageCoreConnection db, SQLiteMasterType type, String tableName) {
        return SQLiteMaster.count(db, type, tableName);
    }

    public static SQLiteMaster queryByType(GeoPackageCoreConnection db, SQLiteMasterType type, String tableName) {
        return SQLiteMaster.query(db, SQLiteMasterColumn.values(), type, tableName);
    }

    public static int countByType(GeoPackageCoreConnection db, Collection<SQLiteMasterType> types, String tableName) {
        return SQLiteMaster.count(db, types.toArray(new SQLiteMasterType[0]), tableName);
    }

    public static SQLiteMaster queryByType(GeoPackageCoreConnection db, Collection<SQLiteMasterType> types, String tableName) {
        return SQLiteMaster.query(db, SQLiteMasterColumn.values(), types.toArray(new SQLiteMasterType[0]), tableName);
    }

    public static int count(GeoPackageCoreConnection db, Collection<SQLiteMasterType> types) {
        return SQLiteMaster.count(db, types, null);
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, Collection<SQLiteMasterColumn> columns, SQLiteMasterType type) {
        return SQLiteMaster.query(db, columns, type, null);
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, Collection<SQLiteMasterColumn> columns, Collection<SQLiteMasterType> types) {
        return SQLiteMaster.query(db, columns, types, null);
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, Collection<SQLiteMasterColumn> columns, SQLiteMasterType type, String tableName) {
        return SQLiteMaster.query(db, columns.toArray(new SQLiteMasterColumn[0]), type, tableName);
    }

    public static int count(GeoPackageCoreConnection db, Collection<SQLiteMasterType> types, String tableName) {
        return SQLiteMaster.count(db, types.toArray(new SQLiteMasterType[0]), tableName);
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, Collection<SQLiteMasterColumn> columns, Collection<SQLiteMasterType> types, String tableName) {
        return SQLiteMaster.query(db, columns.toArray(new SQLiteMasterColumn[0]), types.toArray(new SQLiteMasterType[0]), tableName);
    }

    public static int count(GeoPackageCoreConnection db, SQLiteMasterType type) {
        return SQLiteMaster.count(db, SQLiteMaster.types(type));
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, SQLiteMasterColumn[] columns, SQLiteMasterType type) {
        return SQLiteMaster.query(db, columns, SQLiteMaster.types(type));
    }

    public static int count(GeoPackageCoreConnection db, SQLiteMasterType type, String tableName) {
        return SQLiteMaster.count(db, SQLiteMaster.types(type), tableName);
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, SQLiteMasterColumn[] columns, SQLiteMasterType type, String tableName) {
        return SQLiteMaster.query(db, columns, SQLiteMaster.types(type), tableName);
    }

    public static int count(GeoPackageCoreConnection db, SQLiteMasterType[] types) {
        return SQLiteMaster.count(db, types, SQLiteMasterQuery.create());
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, SQLiteMasterColumn[] columns, SQLiteMasterType[] types) {
        return SQLiteMaster.query(db, columns, types, SQLiteMasterQuery.create());
    }

    public static int count(GeoPackageCoreConnection db, SQLiteMasterType[] types, String tableName) {
        return SQLiteMaster.count(db, types, SQLiteMasterQuery.create(SQLiteMasterColumn.TBL_NAME, tableName));
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, SQLiteMasterColumn[] columns, SQLiteMasterType[] types, String tableName) {
        return SQLiteMaster.query(db, columns, types, SQLiteMasterQuery.create(SQLiteMasterColumn.TBL_NAME, tableName));
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, SQLiteMasterQuery query) {
        return SQLiteMaster.query(db, SQLiteMasterColumn.values(), query);
    }

    public static int count(GeoPackageCoreConnection db, SQLiteMasterQuery query) {
        return SQLiteMaster.count(db, SQLiteMaster.types(new SQLiteMasterType[0]), query);
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, SQLiteMasterColumn[] columns, SQLiteMasterQuery query) {
        return SQLiteMaster.query(db, columns, SQLiteMaster.types(new SQLiteMasterType[0]), query);
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, SQLiteMasterType type, SQLiteMasterQuery query) {
        return SQLiteMaster.query(db, SQLiteMasterColumn.values(), type, query);
    }

    public static int count(GeoPackageCoreConnection db, SQLiteMasterType type, SQLiteMasterQuery query) {
        return SQLiteMaster.count(db, SQLiteMaster.types(type), query);
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, SQLiteMasterColumn[] columns, SQLiteMasterType type, SQLiteMasterQuery query) {
        return SQLiteMaster.query(db, columns, SQLiteMaster.types(type), query);
    }

    public static int count(GeoPackageCoreConnection db, SQLiteMasterType[] types, SQLiteMasterQuery query) {
        return SQLiteMaster.query(db, null, types, query).count();
    }

    public static SQLiteMaster query(GeoPackageCoreConnection db, SQLiteMasterColumn[] columns, SQLiteMasterType[] types, SQLiteMasterQuery query) {
        boolean hasTypes;
        StringBuilder sql = new StringBuilder("SELECT ");
        ArrayList<String> args = new ArrayList<String>();
        if (columns != null && columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(columns[i].name().toLowerCase());
            }
        } else {
            sql.append("count(*)");
        }
        sql.append(" FROM ");
        sql.append(TABLE_NAME);
        boolean hasQuery = query != null && query.has();
        boolean bl = hasTypes = types != null && types.length > 0;
        if (hasQuery || hasTypes) {
            sql.append(" WHERE ");
            if (hasQuery) {
                sql.append(query.buildSQL());
                args.addAll(query.getArguments());
            }
            if (hasTypes) {
                if (hasQuery) {
                    sql.append(" AND");
                }
                sql.append(" type IN (");
                for (int i = 0; i < types.length; ++i) {
                    if (i > 0) {
                        sql.append(", ");
                    }
                    sql.append("?");
                    args.add(types[i].name().toLowerCase());
                }
                sql.append(")");
            }
        }
        List<List<Object>> results = db.queryResults(sql.toString(), args.toArray(new String[0]));
        SQLiteMaster sqliteMaster = new SQLiteMaster(results, columns);
        return sqliteMaster;
    }

    public static SQLiteMaster queryViewsOnTable(GeoPackageCoreConnection db, String tableName) {
        return SQLiteMaster.queryViewsOnTable(db, SQLiteMasterColumn.values(), tableName);
    }

    public static SQLiteMaster queryViewsOnTable(GeoPackageCoreConnection db, SQLiteMasterColumn[] columns, String tableName) {
        return SQLiteMaster.query(db, columns, SQLiteMasterType.VIEW, SQLiteMasterQuery.createTableViewQuery(tableName));
    }

    public static int countViewsOnTable(GeoPackageCoreConnection db, String tableName) {
        return SQLiteMaster.count(db, SQLiteMasterType.VIEW, SQLiteMasterQuery.createTableViewQuery(tableName));
    }

    public static TableConstraints queryForConstraints(GeoPackageCoreConnection db, String tableName) {
        TableConstraints constraints = new TableConstraints();
        SQLiteMaster tableMaster = SQLiteMaster.queryByType(db, SQLiteMasterType.TABLE, tableName);
        for (int i = 0; i < tableMaster.count(); ++i) {
            constraints.addConstraints(tableMaster.getConstraints(i));
        }
        return constraints;
    }
}

