/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.db.AlterTable;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.MappedColumn;
import mil.nga.geopackage.db.TableMapping;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.contents.ContentsIdExtension;
import mil.nga.geopackage.extension.index.FeatureTableCoreIndex;
import mil.nga.geopackage.extension.index.GeometryIndexDao;
import mil.nga.geopackage.extension.index.TableIndex;
import mil.nga.geopackage.extension.index.TableIndexDao;
import mil.nga.geopackage.extension.link.FeatureTileLink;
import mil.nga.geopackage.extension.link.FeatureTileLinkDao;
import mil.nga.geopackage.extension.link.FeatureTileTableCoreLinker;
import mil.nga.geopackage.extension.properties.PropertiesCoreExtension;
import mil.nga.geopackage.extension.related.RelatedTablesCoreExtension;
import mil.nga.geopackage.extension.scale.TileScalingDao;
import mil.nga.geopackage.extension.scale.TileTableScaling;
import mil.nga.geopackage.extension.style.FeatureCoreStyleExtension;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;
import mil.nga.geopackage.user.custom.UserCustomTable;
import mil.nga.geopackage.user.custom.UserCustomTableReader;

public class NGAExtensions {
    private static final Logger logger = Logger.getLogger(NGAExtensions.class.getName());

    public static void deleteTableExtensions(GeoPackageCore geoPackage, String table) {
        NGAExtensions.deleteGeometryIndex(geoPackage, table);
        NGAExtensions.deleteFeatureTileLink(geoPackage, table);
        NGAExtensions.deleteTileScaling(geoPackage, table);
        NGAExtensions.deleteProperties(geoPackage, table);
        NGAExtensions.deleteFeatureStyle(geoPackage, table);
        NGAExtensions.deleteContentsId(geoPackage, table);
    }

    public static void deleteExtensions(GeoPackageCore geoPackage) {
        NGAExtensions.deleteGeometryIndexExtension(geoPackage);
        NGAExtensions.deleteFeatureTileLinkExtension(geoPackage);
        NGAExtensions.deleteTileScalingExtension(geoPackage);
        NGAExtensions.deletePropertiesExtension(geoPackage);
        NGAExtensions.deleteFeatureStyleExtension(geoPackage);
        NGAExtensions.deleteContentsIdExtension(geoPackage);
    }

    public static void copyTableExtensions(GeoPackageCore geoPackage, String table, String newTable) {
        try {
            NGAExtensions.copyContentsId(geoPackage, table, newTable);
            NGAExtensions.copyFeatureStyle(geoPackage, table, newTable);
            NGAExtensions.copyTileScaling(geoPackage, table, newTable);
            NGAExtensions.copyFeatureTileLink(geoPackage, table, newTable);
            NGAExtensions.copyGeometryIndex(geoPackage, table, newTable);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to copy extensions for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    public static void deleteGeometryIndex(GeoPackageCore geoPackage, String table) {
        TableIndexDao tableIndexDao = geoPackage.getTableIndexDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (tableIndexDao.isTableExists()) {
                tableIndexDao.deleteByIdCascade(table);
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(FeatureTableCoreIndex.EXTENSION_NAME, table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table Index. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public static void deleteGeometryIndexExtension(GeoPackageCore geoPackage) {
        GeometryIndexDao geometryIndexDao = geoPackage.getGeometryIndexDao();
        TableIndexDao tableIndexDao = geoPackage.getTableIndexDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (geometryIndexDao.isTableExists()) {
                geoPackage.dropTable(geometryIndexDao.getTableName());
            }
            if (tableIndexDao.isTableExists()) {
                geoPackage.dropTable(tableIndexDao.getTableName());
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(FeatureTableCoreIndex.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table Index extension and tables. GeoPackage: " + geoPackage.getName(), e);
        }
    }

    public static void copyGeometryIndex(GeoPackageCore geoPackage, String table, String newTable) {
        try {
            List<Extensions> extensions;
            ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
            if (extensionsDao.isTableExists() && !(extensions = extensionsDao.queryByExtension(FeatureTableCoreIndex.EXTENSION_NAME, table)).isEmpty()) {
                TableIndex tableIndex;
                Extensions extension = extensions.get(0);
                extension.setTableName(newTable);
                extensionsDao.create(extension);
                TableIndexDao tableIndexDao = geoPackage.getTableIndexDao();
                if (tableIndexDao.isTableExists() && (tableIndex = (TableIndex)tableIndexDao.queryForId(table)) != null) {
                    tableIndex.setTableName(newTable);
                    tableIndexDao.create(tableIndex);
                    if (geoPackage.isTable("nga_geometry_index")) {
                        CoreSQLUtils.transferTableContent(geoPackage.getDatabase(), "nga_geometry_index", "table_name", newTable, table);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Geometry Index for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    public static void deleteFeatureTileLink(GeoPackageCore geoPackage, String table) {
        FeatureTileLinkDao featureTileLinkDao = geoPackage.getFeatureTileLinkDao();
        try {
            if (featureTileLinkDao.isTableExists()) {
                featureTileLinkDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Feature Tile Link. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public static void deleteFeatureTileLinkExtension(GeoPackageCore geoPackage) {
        FeatureTileLinkDao featureTileLinkDao = geoPackage.getFeatureTileLinkDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (featureTileLinkDao.isTableExists()) {
                geoPackage.dropTable(featureTileLinkDao.getTableName());
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(FeatureTileTableCoreLinker.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Feature Tile Link extension and table. GeoPackage: " + geoPackage.getName(), e);
        }
    }

    public static void copyFeatureTileLink(GeoPackageCore geoPackage, String table, String newTable) {
        try {
            FeatureTileLinkDao featureTileLinkDao;
            List<Extensions> extensions;
            ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
            if (extensionsDao.isTableExists() && !(extensions = extensionsDao.queryByExtension(FeatureTileTableCoreLinker.EXTENSION_NAME)).isEmpty() && (featureTileLinkDao = geoPackage.getFeatureTileLinkDao()).isTableExists()) {
                for (FeatureTileLink featureTileLink : featureTileLinkDao.queryForFeatureTableName(table)) {
                    featureTileLink.setFeatureTableName(newTable);
                    featureTileLinkDao.create(featureTileLink);
                }
                for (FeatureTileLink featureTileLink : featureTileLinkDao.queryForTileTableName(table)) {
                    featureTileLink.setTileTableName(newTable);
                    featureTileLinkDao.create(featureTileLink);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Feature Tile Link for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    public static void deleteTileScaling(GeoPackageCore geoPackage, String table) {
        TileScalingDao tileScalingDao = geoPackage.getTileScalingDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (tileScalingDao.isTableExists()) {
                tileScalingDao.deleteById(table);
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(TileTableScaling.EXTENSION_NAME, table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Tile Scaling. GeoPackage: " + geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public static void deleteTileScalingExtension(GeoPackageCore geoPackage) {
        TileScalingDao tileScalingDao = geoPackage.getTileScalingDao();
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        try {
            if (tileScalingDao.isTableExists()) {
                geoPackage.dropTable(tileScalingDao.getTableName());
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(TileTableScaling.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Tile Scaling extension and table. GeoPackage: " + geoPackage.getName(), e);
        }
    }

    public static void copyTileScaling(GeoPackageCore geoPackage, String table, String newTable) {
        try {
            Extensions extension;
            TileTableScaling tileTableScaling = new TileTableScaling(geoPackage, table);
            if (tileTableScaling.has() && (extension = tileTableScaling.getExtension()) != null) {
                extension.setTableName(newTable);
                tileTableScaling.getExtensionsDao().create(extension);
                if (geoPackage.isTable("nga_tile_scaling")) {
                    CoreSQLUtils.transferTableContent(geoPackage.getDatabase(), "nga_tile_scaling", "table_name", newTable, table);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Tile Scaling for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    public static void deleteProperties(GeoPackageCore geoPackage, String table) {
        if (table.equalsIgnoreCase(PropertiesCoreExtension.TABLE_NAME)) {
            NGAExtensions.deletePropertiesExtension(geoPackage);
        }
    }

    public static void deletePropertiesExtension(GeoPackageCore geoPackage) {
        ExtensionsDao extensionsDao = geoPackage.getExtensionsDao();
        if (geoPackage.isTable(PropertiesCoreExtension.TABLE_NAME)) {
            ContentsDao contentsDao = geoPackage.getContentsDao();
            contentsDao.deleteTable(PropertiesCoreExtension.TABLE_NAME);
        }
        try {
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(PropertiesCoreExtension.EXTENSION_NAME, PropertiesCoreExtension.TABLE_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Properties extension. GeoPackage: " + geoPackage.getName(), e);
        }
    }

    public static void deleteFeatureStyle(GeoPackageCore geoPackage, String table) {
        FeatureCoreStyleExtension featureStyleExtension = NGAExtensions.getFeatureStyleExtension(geoPackage);
        if (featureStyleExtension.has(table)) {
            featureStyleExtension.deleteRelationships(table);
        }
    }

    public static void deleteFeatureStyleExtension(GeoPackageCore geoPackage) {
        FeatureCoreStyleExtension featureStyleExtension = NGAExtensions.getFeatureStyleExtension(geoPackage);
        if (featureStyleExtension.has()) {
            featureStyleExtension.removeExtension();
        }
    }

    public static void copyFeatureStyle(GeoPackageCore geoPackage, String table, String newTable) {
        try {
            Extensions extension;
            FeatureCoreStyleExtension featureStyleExtension = NGAExtensions.getFeatureStyleExtension(geoPackage);
            if (featureStyleExtension.hasRelationship(table) && (extension = featureStyleExtension.get(FeatureCoreStyleExtension.EXTENSION_NAME, table, null)) != null) {
                extension.setTableName(newTable);
                featureStyleExtension.getExtensionsDao().create(extension);
                ContentsIdExtension contentsIdExtension = featureStyleExtension.getContentsId();
                Long contentsId = contentsIdExtension.getId(table);
                Long newContentsId = contentsIdExtension.getId(newTable);
                if (contentsId != null && newContentsId != null) {
                    if (featureStyleExtension.hasTableStyleRelationship(table)) {
                        NGAExtensions.copyFeatureTableStyle(featureStyleExtension, "nga_style_default_", table, newTable, contentsId, newContentsId);
                    }
                    if (featureStyleExtension.hasTableIconRelationship(table)) {
                        NGAExtensions.copyFeatureTableStyle(featureStyleExtension, "nga_icon_default_", table, newTable, contentsId, newContentsId);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Feature Style for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    private static void copyFeatureTableStyle(FeatureCoreStyleExtension featureStyleExtension, String mappingTablePrefix, String table, String newTable, long contentsId, long newContentsId) throws SQLException {
        GeoPackageCore geoPackage = featureStyleExtension.getGeoPackage();
        String mappingTableName = featureStyleExtension.getMappingTableName(mappingTablePrefix, table);
        ExtensionsDao extensionsDao = featureStyleExtension.getExtensionsDao();
        List<Extensions> extensions = extensionsDao.queryByExtension(RelatedTablesCoreExtension.EXTENSION_NAME, mappingTableName);
        if (!extensions.isEmpty()) {
            String newMappingTableName = featureStyleExtension.getMappingTableName(mappingTablePrefix, newTable);
            UserCustomTable userTable = UserCustomTableReader.readTable(geoPackage.getDatabase(), mappingTableName);
            AlterTable.copyTable(geoPackage.getDatabase(), userTable, newMappingTableName, false);
            TableMapping mappingTableTableMapping = new TableMapping((UserTable<? extends UserColumn>)userTable, newMappingTableName);
            MappedColumn baseIdColumn = mappingTableTableMapping.getColumn("base_id");
            baseIdColumn.setConstantValue(newContentsId);
            baseIdColumn.setWhereValue(contentsId);
            CoreSQLUtils.transferTableContent(geoPackage.getDatabase(), mappingTableTableMapping);
            Extensions extension = extensions.get(0);
            extension.setTableName(newMappingTableName);
            extensionsDao.create(extension);
            TableMapping extendedRelationTableMapping = new TableMapping(geoPackage.getDatabase(), "gpkgext_relations");
            extendedRelationTableMapping.removeColumn("id");
            MappedColumn baseTableNameColumn = extendedRelationTableMapping.getColumn("base_table_name");
            baseTableNameColumn.setWhereValue("nga_contents_id");
            MappedColumn mappingTableNameColumn = extendedRelationTableMapping.getColumn("mapping_table_name");
            mappingTableNameColumn.setConstantValue(newMappingTableName);
            mappingTableNameColumn.setWhereValue(mappingTableName);
            CoreSQLUtils.transferTableContent(geoPackage.getDatabase(), extendedRelationTableMapping);
        }
    }

    private static FeatureCoreStyleExtension getFeatureStyleExtension(GeoPackageCore geoPackage) {
        RelatedTablesCoreExtension relatedTables = new RelatedTablesCoreExtension(geoPackage){};
        return new FeatureCoreStyleExtension(geoPackage, relatedTables){};
    }

    public static void deleteContentsId(GeoPackageCore geoPackage, String table) {
        ContentsIdExtension contentsIdExtension = new ContentsIdExtension(geoPackage);
        if (contentsIdExtension.has()) {
            contentsIdExtension.delete(table);
        }
    }

    public static void deleteContentsIdExtension(GeoPackageCore geoPackage) {
        ContentsIdExtension contentsIdExtension = new ContentsIdExtension(geoPackage);
        if (contentsIdExtension.has()) {
            contentsIdExtension.removeExtension();
        }
    }

    public static void copyContentsId(GeoPackageCore geoPackage, String table, String newTable) {
        try {
            ContentsIdExtension contentsIdExtension = new ContentsIdExtension(geoPackage);
            if (contentsIdExtension.has() && contentsIdExtension.get(table) != null) {
                contentsIdExtension.create(newTable);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Contents Id for table: " + newTable + ", copied from table: " + table, e);
        }
    }
}

