/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.index;

import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.index.GeometryIndex;
import mil.nga.geopackage.extension.index.GeometryIndexDao;
import mil.nga.geopackage.extension.index.GeometryIndexKey;
import mil.nga.geopackage.extension.index.TableIndex;
import mil.nga.geopackage.extension.index.TableIndexDao;
import mil.nga.geopackage.geom.GeoPackageGeometryData;
import mil.nga.geopackage.io.GeoPackageProgress;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionTransform;

public abstract class FeatureTableCoreIndex
extends BaseExtension {
    private static final Logger logger = Logger.getLogger(FeatureTableCoreIndex.class.getName());
    public static final String EXTENSION_AUTHOR = "nga";
    public static final String EXTENSION_NAME_NO_AUTHOR = "geometry_index";
    public static final String EXTENSION_NAME = Extensions.buildExtensionName("nga", "geometry_index");
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty("geopackage.extensions", "geometry_index");
    private final String tableName;
    private final String columnName;
    private final TableIndexDao tableIndexDao;
    private final GeometryIndexDao geometryIndexDao;
    protected GeoPackageProgress progress;
    protected int chunkLimit = 1000;
    protected double tolerance = 1.0E-14;

    protected FeatureTableCoreIndex(GeoPackageCore geoPackage, String tableName, String columnName) {
        super(geoPackage);
        this.tableName = tableName;
        this.columnName = columnName;
        this.tableIndexDao = geoPackage.getTableIndexDao();
        this.geometryIndexDao = geoPackage.getGeometryIndexDao();
    }

    public abstract Projection getProjection();

    @Override
    public GeoPackageCore getGeoPackage() {
        return this.geoPackage;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setProgress(GeoPackageProgress progress) {
        this.progress = progress;
    }

    public int getChunkLimit() {
        return this.chunkLimit;
    }

    public void setChunkLimit(int chunkLimit) {
        this.chunkLimit = chunkLimit;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public int index() {
        return this.index(false);
    }

    public int index(boolean force) {
        int count = 0;
        if (force || !this.isIndexed()) {
            this.getOrCreateExtension();
            TableIndex tableIndex = this.getOrCreateTableIndex();
            this.createOrClearGeometryIndices();
            this.geoPackage.unindexGeometryIndexTable();
            count = this.indexTable(tableIndex);
            this.geoPackage.indexGeometryIndexTable();
        }
        return count;
    }

    protected abstract int indexTable(TableIndex var1);

    protected boolean index(TableIndex tableIndex, long geomId, GeoPackageGeometryData geomData) {
        GeometryEnvelope envelope;
        boolean indexed = false;
        if (geomData != null && (envelope = geomData.getOrBuildEnvelope()) != null) {
            GeometryIndex geometryIndex = this.geometryIndexDao.populate(tableIndex, geomId, envelope);
            try {
                this.geometryIndexDao.createOrUpdate(geometryIndex);
                indexed = true;
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to create or update Geometry Index. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Geom Id: " + geomId, e);
            }
        }
        return indexed;
    }

    protected void updateLastIndexed() {
        TableIndex tableIndex = new TableIndex();
        tableIndex.setTableName(this.tableName);
        tableIndex.setLastIndexed(new Date());
        try {
            this.tableIndexDao.createOrUpdate(tableIndex);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to update last indexed date. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName, e);
        }
    }

    public boolean deleteIndex() {
        boolean deleted = false;
        ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
        TableIndexDao tableIndexDao = this.geoPackage.getTableIndexDao();
        try {
            if (tableIndexDao.isTableExists()) {
                boolean bl = deleted = tableIndexDao.deleteByIdCascade(this.tableName) > 0;
            }
            if (extensionsDao.isTableExists()) {
                deleted = extensionsDao.deleteByExtension(EXTENSION_NAME, this.tableName) > 0 || deleted;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table Index. GeoPackage: " + this.geoPackage.getName() + ", Table: " + this.tableName, e);
        }
        return deleted;
    }

    public int deleteIndex(long geomId) {
        int deleted = 0;
        GeometryIndexKey key = new GeometryIndexKey(this.tableName, geomId);
        try {
            deleted = this.geometryIndexDao.deleteById(key);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete index, GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Geometry Id: " + geomId, e);
        }
        return deleted;
    }

    public boolean isIndexed() {
        boolean indexed = false;
        Extensions extension = this.getExtension();
        if (extension != null) {
            ContentsDao contentsDao = this.geoPackage.getContentsDao();
            try {
                Contents contents = (Contents)contentsDao.queryForId(this.tableName);
                if (contents != null) {
                    Date lastChange = contents.getLastChange();
                    TableIndexDao tableIndexDao = this.geoPackage.getTableIndexDao();
                    TableIndex tableIndex = (TableIndex)tableIndexDao.queryForId(this.tableName);
                    if (tableIndex != null) {
                        Date lastIndexed = tableIndex.getLastIndexed();
                        indexed = lastIndexed != null && lastIndexed.getTime() >= lastChange.getTime();
                    }
                }
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to check if table is indexed, GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName, e);
            }
        }
        return indexed;
    }

    private TableIndex getOrCreateTableIndex() {
        TableIndex tableIndex = this.getTableIndex();
        if (tableIndex == null) {
            try {
                if (!this.tableIndexDao.isTableExists()) {
                    this.geoPackage.createTableIndexTable();
                }
                tableIndex = new TableIndex();
                tableIndex.setTableName(this.tableName);
                tableIndex.setLastIndexed(null);
                this.tableIndexDao.create(tableIndex);
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to create Table Index for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
            }
        }
        return tableIndex;
    }

    public TableIndex getTableIndex() {
        TableIndex tableIndex = null;
        try {
            if (this.tableIndexDao.isTableExists()) {
                tableIndex = (TableIndex)this.tableIndexDao.queryForId(this.tableName);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Table Index for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return tableIndex;
    }

    public Date getLastIndexed() {
        Date lastIndexed = null;
        TableIndex tableIndex = this.getTableIndex();
        if (tableIndex != null) {
            lastIndexed = tableIndex.getLastIndexed();
        }
        return lastIndexed;
    }

    private void createOrClearGeometryIndices() {
        if (!this.createGeometryIndexTable()) {
            this.clearGeometryIndices();
        }
    }

    private int clearGeometryIndices() {
        int deleted = 0;
        DeleteBuilder db = this.geometryIndexDao.deleteBuilder();
        try {
            db.where().eq("table_name", (Object)this.tableName);
            PreparedDelete deleteQuery = db.prepare();
            deleted = this.geometryIndexDao.delete(deleteQuery);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to clear Geometry Index rows for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return deleted;
    }

    private boolean createGeometryIndexTable() {
        boolean created = false;
        try {
            if (!this.geometryIndexDao.isTableExists()) {
                created = this.geoPackage.createGeometryIndexTable();
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create Geometry Index table for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return created;
    }

    private Extensions getOrCreateExtension() {
        Extensions extension = this.getOrCreate(EXTENSION_NAME, this.tableName, this.columnName, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        return extension;
    }

    public Extensions getExtension() {
        Extensions extension = this.get(EXTENSION_NAME, this.tableName, this.columnName);
        return extension;
    }

    public CloseableIterator<GeometryIndex> query() {
        CloseableIterator geometryIndices = null;
        QueryBuilder<GeometryIndex, GeometryIndexKey> qb = this.queryBuilder();
        try {
            geometryIndices = qb.iterator();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for all Geometry Indices. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return geometryIndices;
    }

    public long count() {
        long count = 0L;
        QueryBuilder<GeometryIndex, GeometryIndexKey> qb = this.queryBuilder();
        try {
            count = qb.countOf();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Geometry Index count. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return count;
    }

    public BoundingBox getBoundingBox() {
        GenericRawResults results = null;
        Object[] values = null;
        try {
            results = this.geometryIndexDao.queryRaw("SELECT MIN(min_x), MIN(min_y), MAX(max_x), MAX(max_y) FROM nga_geometry_index WHERE table_name = ?", new DataType[]{DataType.DOUBLE, DataType.DOUBLE, DataType.DOUBLE, DataType.DOUBLE}, new String[]{this.tableName});
            values = (Object[])results.getFirstResult();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for indexed feature bounds: " + this.tableName, e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close bounds query results", e);
                }
            }
        }
        BoundingBox boundingBox = new BoundingBox((Double)values[0], (Double)values[1], (Double)values[2], (Double)values[3]);
        return boundingBox;
    }

    public BoundingBox getBoundingBox(Projection projection) {
        BoundingBox boundingBox = this.getBoundingBox();
        if (boundingBox != null && projection != null) {
            ProjectionTransform projectionTransform = this.getProjection().getTransformation(projection);
            boundingBox = boundingBox.transform(projectionTransform);
        }
        return boundingBox;
    }

    public QueryBuilder<GeometryIndex, GeometryIndexKey> queryBuilder() {
        QueryBuilder qb = this.geometryIndexDao.queryBuilder();
        try {
            qb.where().eq("table_name", (Object)this.tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to build query for all Geometry Indices. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return qb;
    }

    public CloseableIterator<GeometryIndex> query(BoundingBox boundingBox) {
        GeometryEnvelope envelope = boundingBox.buildEnvelope();
        CloseableIterator<GeometryIndex> geometryIndices = this.query(envelope);
        return geometryIndices;
    }

    public CloseableIterator<GeometryIndex> query(BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.getFeatureBoundingBox(boundingBox, projection);
        CloseableIterator<GeometryIndex> geometryIndices = this.query(featureBoundingBox);
        return geometryIndices;
    }

    public long count(BoundingBox boundingBox) {
        GeometryEnvelope envelope = boundingBox.buildEnvelope();
        long count = this.count(envelope);
        return count;
    }

    public long count(BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.getFeatureBoundingBox(boundingBox, projection);
        long count = this.count(featureBoundingBox);
        return count;
    }

    public CloseableIterator<GeometryIndex> query(GeometryEnvelope envelope) {
        CloseableIterator geometryIndices = null;
        QueryBuilder<GeometryIndex, GeometryIndexKey> qb = this.queryBuilder(envelope);
        try {
            geometryIndices = qb.iterator();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Geometry Indices. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return geometryIndices;
    }

    public long count(GeometryEnvelope envelope) {
        long count = 0L;
        QueryBuilder<GeometryIndex, GeometryIndexKey> qb = this.queryBuilder(envelope);
        try {
            count = qb.countOf();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for Geometry Index count. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return count;
    }

    public QueryBuilder<GeometryIndex, GeometryIndexKey> queryBuilder(GeometryEnvelope envelope) {
        QueryBuilder qb = this.geometryIndexDao.queryBuilder();
        try {
            double minX = envelope.getMinX() - this.tolerance;
            double maxX = envelope.getMaxX() + this.tolerance;
            double minY = envelope.getMinY() - this.tolerance;
            double maxY = envelope.getMaxY() + this.tolerance;
            Where where = qb.where();
            where.eq("table_name", (Object)this.tableName).and().le("min_x", (Object)maxX).and().ge("max_x", (Object)minX).and().le("min_y", (Object)maxY).and().ge("max_y", (Object)minY);
            if (envelope.hasZ()) {
                double minZ = envelope.getMinZ() - this.tolerance;
                double maxZ = envelope.getMaxZ() + this.tolerance;
                where.and().le("min_z", (Object)maxZ).and().ge("max_z", (Object)minZ);
            }
            if (envelope.hasM()) {
                double minM = envelope.getMinM() - this.tolerance;
                double maxM = envelope.getMaxM() + this.tolerance;
                where.and().le("min_m", (Object)maxM).and().ge("max_m", (Object)minM);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to build query for Geometry Indices. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + this.tableName + ", Column Name: " + this.columnName, e);
        }
        return qb;
    }

    protected BoundingBox getFeatureBoundingBox(BoundingBox boundingBox, Projection projection) {
        ProjectionTransform projectionTransform = projection.getTransformation(this.getProjection());
        BoundingBox featureBoundingBox = boundingBox.transform(projectionTransform);
        return featureBoundingBox;
    }
}

