/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.related;

import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.user.custom.UserCustomColumn;
import mil.nga.geopackage.user.custom.UserCustomTable;

public class UserMappingTable
extends UserCustomTable {
    public static final String COLUMN_BASE_ID = "base_id";
    public static final String COLUMN_RELATED_ID = "related_id";

    public static UserMappingTable create(String tableName) {
        return UserMappingTable.create(tableName, null);
    }

    public static UserMappingTable create(String tableName, List<UserCustomColumn> additionalColumns) {
        ArrayList<UserCustomColumn> columns = new ArrayList<UserCustomColumn>();
        columns.addAll(UserMappingTable.createRequiredColumns());
        if (additionalColumns != null) {
            columns.addAll(additionalColumns);
        }
        return new UserMappingTable(tableName, (List<UserCustomColumn>)columns);
    }

    public static List<UserCustomColumn> createRequiredColumns() {
        ArrayList<UserCustomColumn> columns = new ArrayList<UserCustomColumn>();
        columns.add(UserMappingTable.createBaseIdColumn());
        columns.add(UserMappingTable.createRelatedIdColumn());
        return columns;
    }

    public static List<UserCustomColumn> createRequiredColumns(int startingIndex) {
        ArrayList<UserCustomColumn> columns = new ArrayList<UserCustomColumn>();
        columns.add(UserMappingTable.createBaseIdColumn(startingIndex++));
        columns.add(UserMappingTable.createRelatedIdColumn(startingIndex++));
        return columns;
    }

    public static UserCustomColumn createBaseIdColumn() {
        return UserMappingTable.createBaseIdColumn(-1);
    }

    public static UserCustomColumn createBaseIdColumn(int index) {
        return UserCustomColumn.createColumn(index, COLUMN_BASE_ID, GeoPackageDataType.INTEGER, true);
    }

    public static UserCustomColumn createRelatedIdColumn() {
        return UserMappingTable.createRelatedIdColumn(-1);
    }

    public static UserCustomColumn createRelatedIdColumn(int index) {
        return UserCustomColumn.createColumn(index, COLUMN_RELATED_ID, GeoPackageDataType.INTEGER, true);
    }

    public static int numRequiredColumns() {
        return UserMappingTable.requiredColumns().size();
    }

    public static List<String> requiredColumns() {
        ArrayList<String> requiredColumns = new ArrayList<String>();
        requiredColumns.add(COLUMN_BASE_ID);
        requiredColumns.add(COLUMN_RELATED_ID);
        return requiredColumns;
    }

    protected UserMappingTable(String tableName, List<UserCustomColumn> columns) {
        super(tableName, columns, UserMappingTable.requiredColumns());
    }

    protected UserMappingTable(UserCustomTable table) {
        super(table);
    }

    public int getBaseIdColumnIndex() {
        return this.getColumnIndex(COLUMN_BASE_ID);
    }

    public UserCustomColumn getBaseIdColumn() {
        return (UserCustomColumn)this.getColumn(COLUMN_BASE_ID);
    }

    public int getRelatedIdColumnIndex() {
        return this.getColumnIndex(COLUMN_RELATED_ID);
    }

    public UserCustomColumn getRelatedIdColumn() {
        return (UserCustomColumn)this.getColumn(COLUMN_RELATED_ID);
    }
}

