/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.io.GeoPackageProgress;

public class GeoPackageIOUtils {
    private static final Logger logger = Logger.getLogger(GeoPackageIOUtils.class.getName());
    public static int COPY_BUFFER_SIZE = 8192;

    public static String getFileExtension(File file) {
        String fileName = file.getName();
        String extension = null;
        int extensionIndex = fileName.lastIndexOf(".");
        if (extensionIndex > -1) {
            extension = fileName.substring(extensionIndex + 1);
        }
        return extension;
    }

    public static boolean hasFileExtension(File file) {
        return GeoPackageIOUtils.getFileExtension(file) != null;
    }

    public static File addFileExtension(File file, String extension) {
        return new File(file.getAbsolutePath() + "." + extension);
    }

    public static String getFileNameWithoutExtension(File file) {
        String name = file.getName();
        int extensionIndex = name.lastIndexOf(".");
        if (extensionIndex > -1) {
            name = name.substring(0, extensionIndex);
        }
        return name;
    }

    public static void copyFile(File copyFrom, File copyTo) throws IOException {
        FileInputStream from = new FileInputStream(copyFrom);
        FileOutputStream to = new FileOutputStream(copyTo);
        GeoPackageIOUtils.copyStream((InputStream)from, to);
    }

    public static void copyStream(InputStream copyFrom, File copyTo) throws IOException {
        GeoPackageIOUtils.copyStream(copyFrom, copyTo, null);
    }

    public static void copyStream(InputStream copyFrom, File copyTo, GeoPackageProgress progress) throws IOException {
        FileOutputStream to = new FileOutputStream(copyTo);
        GeoPackageIOUtils.copyStream(copyFrom, to, progress);
        if (progress != null && !progress.isActive() && progress.cleanupOnCancel()) {
            copyTo.delete();
        }
    }

    public static byte[] fileBytes(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return GeoPackageIOUtils.streamBytes(fis);
    }

    public static byte[] streamBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        GeoPackageIOUtils.copyStream(stream, bytes);
        return bytes.toByteArray();
    }

    public static String streamString(InputStream stream) throws IOException {
        return GeoPackageIOUtils.streamString(stream, "UTF-8");
    }

    public static String streamString(InputStream stream, String charsetName) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        GeoPackageIOUtils.copyStream(stream, bytes);
        return bytes.toString(charsetName);
    }

    public static void copyStream(InputStream copyFrom, OutputStream copyTo) throws IOException {
        GeoPackageIOUtils.copyStream(copyFrom, copyTo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream copyFrom, OutputStream copyTo, GeoPackageProgress progress) throws IOException {
        try {
            int length;
            byte[] buffer = new byte[COPY_BUFFER_SIZE];
            while ((progress == null || progress.isActive()) && (length = copyFrom.read(buffer)) > 0) {
                copyTo.write(buffer, 0, length);
                if (progress == null) continue;
                progress.addProgress(length);
            }
            copyTo.flush();
        }
        finally {
            GeoPackageIOUtils.closeQuietly(copyTo);
            GeoPackageIOUtils.closeQuietly(copyFrom);
        }
    }

    public static String formatBytes(long bytes) {
        double value = bytes;
        String unit = "B";
        if (bytes >= 1024L) {
            int exponent = (int)(Math.log(bytes) / Math.log(1024.0));
            exponent = Math.min(exponent, 4);
            switch (exponent) {
                case 1: {
                    unit = "KB";
                    break;
                }
                case 2: {
                    unit = "MB";
                    break;
                }
                case 3: {
                    unit = "GB";
                    break;
                }
                case 4: {
                    unit = "TB";
                }
            }
            value = (double)bytes / Math.pow(1024.0, exponent);
        }
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(value) + " " + unit;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to close closeable", e);
        }
    }
}

