/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.core.contents;

import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.IOException;
import java.util.Date;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.persister.DatePersister;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionTransform;

@DatabaseTable(tableName="gpkg_contents", daoClass=ContentsDao.class)
public class Contents {
    public static final String TABLE_NAME = "gpkg_contents";
    public static final String COLUMN_TABLE_NAME = "table_name";
    public static final String COLUMN_ID = "table_name";
    public static final String COLUMN_DATA_TYPE = "data_type";
    public static final String COLUMN_IDENTIFIER = "identifier";
    public static final String COLUMN_DESCRIPTION = "description";
    public static final String COLUMN_LAST_CHANGE = "last_change";
    public static final String COLUMN_MIN_X = "min_x";
    public static final String COLUMN_MIN_Y = "min_y";
    public static final String COLUMN_MAX_X = "max_x";
    public static final String COLUMN_MAX_Y = "max_y";
    public static final String COLUMN_SRS_ID = "srs_id";
    @DatabaseField(columnName="table_name", id=true, canBeNull=false)
    private String tableName;
    @DatabaseField(columnName="data_type", canBeNull=false)
    private String dataType;
    @DatabaseField(columnName="identifier", unique=true)
    private String identifier;
    @DatabaseField(columnName="description", defaultValue="")
    private String description;
    @DatabaseField(columnName="last_change", persisterClass=DatePersister.class, defaultValue="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date lastChange;
    @DatabaseField(columnName="min_x")
    private Double minX;
    @DatabaseField(columnName="min_y")
    private Double minY;
    @DatabaseField(columnName="max_x")
    private Double maxX;
    @DatabaseField(columnName="max_y")
    private Double maxY;
    @DatabaseField(columnName="srs_id", foreign=true, foreignAutoRefresh=true)
    private SpatialReferenceSystem srs;
    @DatabaseField(columnName="srs_id", readOnly=true)
    private Long srsId;
    @ForeignCollectionField(eager=false)
    private ForeignCollection<GeometryColumns> geometryColumns;
    @ForeignCollectionField(eager=false)
    private ForeignCollection<TileMatrixSet> tileMatrixSet;
    @ForeignCollectionField(eager=false)
    private ForeignCollection<TileMatrix> tileMatrix;

    public Contents() {
    }

    public Contents(Contents contents) {
        this.tableName = contents.tableName;
        this.dataType = contents.dataType;
        this.identifier = contents.identifier;
        this.description = contents.description;
        this.lastChange = new Date(contents.lastChange.getTime());
        this.minX = contents.minX;
        this.maxX = contents.maxX;
        this.minY = contents.minY;
        this.maxY = contents.maxY;
        this.srs = contents.srs;
        this.srsId = contents.srsId;
    }

    public String getId() {
        return this.tableName;
    }

    public void setId(String id) {
        this.tableName = id;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ContentsDataType getDataType() {
        return ContentsDataType.fromName(this.dataType);
    }

    public void setDataType(ContentsDataType dataType) {
        this.dataType = dataType.getName();
    }

    public String getDataTypeString() {
        return this.dataType;
    }

    public void setDataTypeString(String dataType) {
        this.dataType = dataType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(Date lastChange) {
        this.lastChange = lastChange;
    }

    public Double getMinX() {
        return this.minX;
    }

    public void setMinX(Double minX) {
        this.minX = minX;
    }

    public Double getMinY() {
        return this.minY;
    }

    public void setMinY(Double minY) {
        this.minY = minY;
    }

    public Double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(Double maxX) {
        this.maxX = maxX;
    }

    public Double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(Double maxY) {
        this.maxY = maxY;
    }

    public SpatialReferenceSystem getSrs() {
        return this.srs;
    }

    public void setSrs(SpatialReferenceSystem srs) {
        this.srs = srs;
        this.srsId = srs != null ? Long.valueOf(srs.getId()) : null;
    }

    public Long getSrsId() {
        return this.srsId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeometryColumns getGeometryColumns() {
        GeometryColumns result = null;
        if (this.geometryColumns.size() > 1) {
            throw new GeoPackageException("Unexpected state. More than one GeometryColumn has a foreign key to the Contents. Count: " + this.geometryColumns.size());
        }
        if (this.geometryColumns.size() == 1) {
            CloseableIterator iterator = this.geometryColumns.closeableIterator();
            try {
                result = (GeometryColumns)iterator.next();
            }
            finally {
                try {
                    iterator.close();
                }
                catch (IOException e) {
                    throw new GeoPackageException("Failed to close the Geometry Columns iterator", e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileMatrixSet getTileMatrixSet() {
        TileMatrixSet result = null;
        if (this.tileMatrixSet.size() > 1) {
            throw new GeoPackageException("Unexpected state. More than one TileMatrixSet has a foreign key to the Contents. Count: " + this.tileMatrixSet.size());
        }
        if (this.tileMatrixSet.size() == 1) {
            CloseableIterator iterator = this.tileMatrixSet.closeableIterator();
            try {
                result = (TileMatrixSet)iterator.next();
            }
            finally {
                try {
                    iterator.close();
                }
                catch (IOException e) {
                    throw new GeoPackageException("Failed to close the Tile Matrix Set iterator", e);
                }
            }
        }
        return result;
    }

    public ForeignCollection<TileMatrix> getTileMatrix() {
        return this.tileMatrix;
    }

    public BoundingBox getBoundingBox() {
        BoundingBox boundingBox = null;
        if (this.minX != null && this.maxX != null && this.minY != null && this.maxY != null) {
            boundingBox = new BoundingBox(this.getMinX(), this.getMinY(), this.getMaxX(), this.getMaxY());
        }
        return boundingBox;
    }

    public BoundingBox getBoundingBox(Projection projection) {
        ProjectionTransform transform;
        BoundingBox boundingBox = this.getBoundingBox();
        if (boundingBox != null && projection != null && !(transform = this.getProjection().getTransformation(projection)).isSameProjection()) {
            boundingBox = boundingBox.transform(transform);
        }
        return boundingBox;
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.setMinX(boundingBox.getMinLongitude());
        this.setMaxX(boundingBox.getMaxLongitude());
        this.setMinY(boundingBox.getMinLatitude());
        this.setMaxY(boundingBox.getMaxLatitude());
    }

    public Projection getProjection() {
        return this.getSrs().getProjection();
    }
}

