/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.core.contents;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrix.TileMatrixDao;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSetDao;
import mil.nga.sf.proj.Projection;

public class ContentsDao
extends BaseDaoImpl<Contents, String> {
    private GeoPackageCoreConnection db;
    private GeometryColumnsDao geometryColumnsDao;
    private TileMatrixSetDao tileMatrixSetDao;
    private TileMatrixDao tileMatrixDao;

    public ContentsDao(ConnectionSource connectionSource, Class<Contents> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public void setDatabase(GeoPackageCoreConnection db) {
        this.db = db;
    }

    public int create(Contents contents) throws SQLException {
        this.verifyCreate(contents);
        return super.create((Object)contents);
    }

    public Contents createIfNotExists(Contents contents) throws SQLException {
        this.verifyCreate(contents);
        return (Contents)super.createIfNotExists((Object)contents);
    }

    public Dao.CreateOrUpdateStatus createOrUpdate(Contents contents) throws SQLException {
        this.verifyCreate(contents);
        return super.createOrUpdate((Object)contents);
    }

    public List<String> getTables(ContentsDataType dataType) throws SQLException {
        return this.getTables(dataType.getName());
    }

    public List<String> getTables(String dataType) throws SQLException {
        List<Contents> contents = this.getContents(dataType);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Contents content : contents) {
            tableNames.add(content.getTableName());
        }
        return tableNames;
    }

    public List<Contents> getContents(ContentsDataType dataType) throws SQLException {
        return this.getContents(dataType.getName());
    }

    public List<Contents> getContents(String dataType) throws SQLException {
        List contents = this.queryForEq("data_type", dataType);
        return contents;
    }

    public List<String> getTables() throws SQLException {
        List contents = this.queryForAll();
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Contents content : contents) {
            tableNames.add(content.getTableName());
        }
        return tableNames;
    }

    public BoundingBox getBoundingBox(Projection projection) {
        BoundingBox boundingBox = null;
        List<String> tables = null;
        try {
            tables = this.getTables();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for contents tables", e);
        }
        for (String table : tables) {
            BoundingBox tableBoundingBox = this.getBoundingBox(projection, table);
            if (tableBoundingBox == null) continue;
            if (boundingBox != null) {
                boundingBox = boundingBox.union(tableBoundingBox);
                continue;
            }
            boundingBox = tableBoundingBox;
        }
        return boundingBox;
    }

    public BoundingBox getBoundingBox(String table) {
        return this.getBoundingBox(null, table);
    }

    public BoundingBox getBoundingBox(Projection projection, String table) {
        BoundingBox boundingBox = null;
        try {
            Contents contents = (Contents)this.queryForId(table);
            boundingBox = contents.getBoundingBox(projection);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for contents of table: " + table, e);
        }
        return boundingBox;
    }

    public int deleteCascade(Contents contents) throws SQLException {
        int count;
        block8: {
            block10: {
                block9: {
                    count = 0;
                    if (contents == null) break block8;
                    ContentsDataType dataType = contents.getDataType();
                    if (dataType == null) break block9;
                    switch (dataType) {
                        case FEATURES: {
                            GeometryColumnsDao geometryColumnsDao = this.getGeometryColumnsDao();
                            if (!geometryColumnsDao.isTableExists()) break;
                            GeometryColumns geometryColumns = contents.getGeometryColumns();
                            if (geometryColumns != null) {
                                geometryColumnsDao.delete(geometryColumns);
                                break;
                            }
                            break block10;
                        }
                        case TILES: 
                        case GRIDDED_COVERAGE: {
                            TileMatrixSetDao tileMatrixSetDao;
                            ForeignCollection<TileMatrix> tileMatrixCollection;
                            TileMatrixDao tileMatrixDao = this.getTileMatrixDao();
                            if (tileMatrixDao.isTableExists() && !(tileMatrixCollection = contents.getTileMatrix()).isEmpty()) {
                                tileMatrixDao.delete((Collection)tileMatrixCollection);
                            }
                            if (!(tileMatrixSetDao = this.getTileMatrixSetDao()).isTableExists()) break;
                            TileMatrixSet tileMatrixSet = contents.getTileMatrixSet();
                            if (tileMatrixSet != null) {
                                tileMatrixSetDao.delete(tileMatrixSet);
                                break;
                            }
                            break block10;
                        }
                        case ATTRIBUTES: {
                            this.dropTable(contents.getTableName());
                        }
                    }
                    break block10;
                }
                this.dropTable(contents.getTableName());
            }
            count = this.delete(contents);
        }
        return count;
    }

    public int deleteCascade(Contents contents, boolean userTable) throws SQLException {
        int count = this.deleteCascade(contents);
        if (userTable) {
            this.dropTable(contents.getTableName());
        }
        return count;
    }

    public int deleteCascade(Collection<Contents> contentsCollection) throws SQLException {
        return this.deleteCascade(contentsCollection, false);
    }

    public int deleteCascade(Collection<Contents> contentsCollection, boolean userTable) throws SQLException {
        int count = 0;
        if (contentsCollection != null) {
            for (Contents contents : contentsCollection) {
                count += this.deleteCascade(contents, userTable);
            }
        }
        return count;
    }

    public int deleteCascade(PreparedQuery<Contents> preparedDelete) throws SQLException {
        return this.deleteCascade(preparedDelete, false);
    }

    public int deleteCascade(PreparedQuery<Contents> preparedDelete, boolean userTable) throws SQLException {
        int count = 0;
        if (preparedDelete != null) {
            List contentsList = this.query(preparedDelete);
            count = this.deleteCascade(contentsList, userTable);
        }
        return count;
    }

    public int deleteByIdCascade(String id) throws SQLException {
        return this.deleteByIdCascade(id, false);
    }

    public int deleteByIdCascade(String id, boolean userTable) throws SQLException {
        int count = 0;
        if (id != null) {
            Contents contents = (Contents)this.queryForId(id);
            if (contents != null) {
                count = this.deleteCascade(contents, userTable);
            } else if (userTable) {
                this.dropTable(id);
            }
        }
        return count;
    }

    public int deleteIdsCascade(Collection<String> idCollection) throws SQLException {
        return this.deleteIdsCascade(idCollection, false);
    }

    public int deleteIdsCascade(Collection<String> idCollection, boolean userTable) throws SQLException {
        int count = 0;
        if (idCollection != null) {
            for (String id : idCollection) {
                count += this.deleteByIdCascade(id, userTable);
            }
        }
        return count;
    }

    public void deleteTable(String table) {
        try {
            this.deleteByIdCascade(table, true);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete table: " + table, e);
        }
    }

    private void dropTable(String table) {
        CoreSQLUtils.dropTable(this.db, table);
    }

    private void verifyCreate(Contents contents) throws SQLException {
        ContentsDataType dataType = contents.getDataType();
        if (dataType != null) {
            switch (dataType) {
                case FEATURES: {
                    GeometryColumnsDao geometryColumnsDao = this.getGeometryColumnsDao();
                    if (geometryColumnsDao.isTableExists()) break;
                    throw new GeoPackageException("A data type of " + dataType.getName() + " requires the " + GeometryColumns.class.getSimpleName() + " table to first be created using the GeoPackage.");
                }
                case TILES: {
                    this.verifyTiles(dataType);
                    break;
                }
                case GRIDDED_COVERAGE: {
                    this.verifyTiles(dataType);
                    break;
                }
                case ATTRIBUTES: {
                    break;
                }
                default: {
                    throw new GeoPackageException("Unsupported data type: " + (Object)((Object)dataType));
                }
            }
        }
        if (!this.db.tableExists(contents.getTableName())) {
            throw new GeoPackageException("No table exists for Content Table Name: " + contents.getTableName() + ". Table must first be created.");
        }
    }

    private void verifyTiles(ContentsDataType dataType) throws SQLException {
        TileMatrixSetDao tileMatrixSetDao = this.getTileMatrixSetDao();
        if (!tileMatrixSetDao.isTableExists()) {
            throw new GeoPackageException("A data type of " + dataType.getName() + " requires the " + TileMatrixSet.class.getSimpleName() + " table to first be created using the GeoPackage.");
        }
        TileMatrixDao tileMatrixDao = this.getTileMatrixDao();
        if (!tileMatrixDao.isTableExists()) {
            throw new GeoPackageException("A data type of " + dataType.getName() + " requires the " + TileMatrix.class.getSimpleName() + " table to first be created using the GeoPackage.");
        }
    }

    private GeometryColumnsDao getGeometryColumnsDao() throws SQLException {
        if (this.geometryColumnsDao == null) {
            this.geometryColumnsDao = (GeometryColumnsDao)DaoManager.createDao((ConnectionSource)this.connectionSource, GeometryColumns.class);
        }
        return this.geometryColumnsDao;
    }

    private TileMatrixSetDao getTileMatrixSetDao() throws SQLException {
        if (this.tileMatrixSetDao == null) {
            this.tileMatrixSetDao = (TileMatrixSetDao)DaoManager.createDao((ConnectionSource)this.connectionSource, TileMatrixSet.class);
        }
        return this.tileMatrixSetDao;
    }

    private TileMatrixDao getTileMatrixDao() throws SQLException {
        if (this.tileMatrixDao == null) {
            this.tileMatrixDao = (TileMatrixDao)DaoManager.createDao((ConnectionSource)this.connectionSource, TileMatrix.class);
        }
        return this.tileMatrixDao;
    }
}

