/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db.table;

import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.db.table.Constraint;
import mil.nga.geopackage.db.table.ConstraintType;
import mil.nga.geopackage.user.UserColumn;

public class UniqueConstraint
extends Constraint {
    public static final String UNIQUE = "UNIQUE";
    private final List<UserColumn> columns = new ArrayList<UserColumn>();

    public UniqueConstraint() {
        super(ConstraintType.UNIQUE);
    }

    public UniqueConstraint(String name) {
        super(ConstraintType.UNIQUE, name);
    }

    public UniqueConstraint(UserColumn ... columns) {
        super(ConstraintType.UNIQUE);
        this.add(columns);
    }

    public UniqueConstraint(String name, UserColumn ... columns) {
        super(ConstraintType.UNIQUE, name);
        this.add(columns);
    }

    public UniqueConstraint(UniqueConstraint userUniqueConstraint) {
        super(ConstraintType.UNIQUE, userUniqueConstraint.getName());
        for (UserColumn column : userUniqueConstraint.columns) {
            this.add(column.copy());
        }
    }

    @Override
    public String buildSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(this.buildNameSql());
        sql.append(UNIQUE);
        sql.append(" (");
        for (int i = 0; i < this.columns.size(); ++i) {
            UserColumn column = this.columns.get(i);
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(column.getName());
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    public UniqueConstraint copy() {
        return new UniqueConstraint(this);
    }

    public void add(UserColumn ... columns) {
        for (UserColumn column : columns) {
            this.columns.add(column);
        }
    }

    public List<UserColumn> getColumns() {
        return this.columns;
    }
}

